/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalOrderColumn;

/**
 * The external form of a order column, which is a child of an element collection mapping.
 *
 * @see ElementCollectionMapping
 *
 * @version 2.5
 * @author Les Davis
 */
@SuppressWarnings("nls")
final class OrderColumn extends AbstractExternalForm
                        implements ExternalOrderColumn {

	/**
	 * The attribute name used to store and retrieve the base property.
	 */
	static final String BASE = "base";

	/**
	 * The attribute name used to store and retrieve the column-definition of the property.
	 */
	static final String COLUMN_DEFINITION = "column-definition";

	/**
	 * The attribute name used to store and retrieve the contiguous property.
	 */
	static final String CONTIGUOUS = "contiguous";

	/**
	 * The attribute name used to store and retrieve the insertable property.
	 */
	static final String INSERTABLE = "insertable";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	static final String NAME = "name";

	/**
	 * The attribute name used to store and retrieve the nullable property.
	 */
	static final String NULLABLE = "nullable";

	/**
	 * The attribute name used to store and retrieve the primary-key of the property.
	 */
	static final String ORDER_COLUMN = "order-column";

	/**
	 * The attribute name used to store and retrieve the table property.
	 */
	static final String TABLE = "table";

	/**
	 * The attribute name used to store and retrieve the updatable property.
	 */
	static final String UPDATABLE = "updatable";

	/**
	 * Creates a new <code>OrderColumn</code>.
	 *
	 * @param parent The parent of this external form
	 */
	OrderColumn(ElementCollectionMapping parent) {
		super(parent);
	}

	/**
	 * Creates a new <code>OrderColumn</code>.
	 *
	 * @param parent The parent of this external form
	 */
	OrderColumn(ObjectCollectionMapping parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(NAME);
		names.add(NULLABLE);
		names.add(INSERTABLE);
		names.add(UPDATABLE);
		names.add(COLUMN_DEFINITION);
		names.add(CONTIGUOUS);
		names.add(BASE);
		names.add(TABLE);
		return names;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getBase() {
		return getIntegerAttribute(BASE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getColumnDefinition() {
		return getAttribute(COLUMN_DEFINITION);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return ORDER_COLUMN;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return getAttribute(NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getTable() {
		return getAttribute(TABLE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Boolean isContiguous() {
		return getBooleanAttribute(CONTIGUOUS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Boolean isInstertable() {
		return getBooleanAttribute(INSERTABLE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Boolean isNullable() {
		return getBooleanAttribute(NULLABLE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Boolean isUpdatable() {
		return getBooleanAttribute(UPDATABLE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeColumn() {
		removeSelf();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setBase(Integer base) {
		setAttribute(BASE, base);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setColumnDefinition(String columnDefinition) {
		setAttribute(COLUMN_DEFINITION, columnDefinition);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setContiguous(Boolean contiguous) {
		setAttribute(CONTIGUOUS, contiguous);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setInsertable(Boolean insertable) {
		setAttribute(INSERTABLE, insertable);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		setAttribute(NAME, name);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setNullable(Boolean nullable) {
		setAttribute(NULLABLE, nullable);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setTable(String table) {
		setAttribute(TABLE, table);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setUpdatable(Boolean updatable) {
		setAttribute(UPDATABLE, updatable);
	}
}