/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.Agent;
import org.eclipse.persistence.testing.models.aggregate.Builder;

public class AgentBuilderTablesTest
extends TestCase {
    public AgentBuilderTablesTest() {
        this.setDescription("Test verifies that correct tables are used by nested aggregate collection mappings");
    }

    public void verify() {
        String errorMsg = "";
        errorMsg = errorMsg + this.verifyDescriptorWithAggColMappingsAndChildren(this.getSession().getDescriptor(Agent.class), false, "Agent");
        if ((errorMsg = errorMsg + this.verifyDescriptorWithAggColMappingsAndChildren(this.getSession().getDescriptor(Builder.class), true, "Builder")).length() > 0) {
            throw new TestErrorException("\n" + errorMsg);
        }
    }

    String verifyDescriptorWithAggColMappingsAndChildren(ClassDescriptor desc, boolean tableNameShouldStartWithBuilder, String attributeName) {
        String localErrorMsg = this.verifyDescriptorWithChildren(desc, tableNameShouldStartWithBuilder, attributeName);
        boolean hasAggregateCollectionMapping = false;
        for (DatabaseMapping mapping : desc.getMappings()) {
            if (!mapping.isAggregateCollectionMapping()) continue;
            AggregateCollectionMapping acMapping = (AggregateCollectionMapping)mapping;
            localErrorMsg = localErrorMsg + this.verifyDescriptorWithAggColMappingsAndChildren(acMapping.getReferenceDescriptor(), tableNameShouldStartWithBuilder, attributeName + "." + acMapping.getAttributeName());
        }
        return localErrorMsg;
    }

    String verifyDescriptorWithChildren(ClassDescriptor desc, boolean tableNameShouldStartWithBuilder, String attributeName) {
        String localErrorMsg = this.verifyDescriptor(desc, tableNameShouldStartWithBuilder, attributeName);
        if (desc.hasInheritance() && desc.getInheritancePolicy().hasChildren()) {
            for (ClassDescriptor childDesc : desc.getInheritancePolicy().getChildDescriptors()) {
                localErrorMsg = localErrorMsg + this.verifyDescriptor(childDesc, tableNameShouldStartWithBuilder, attributeName);
            }
        }
        return localErrorMsg;
    }

    String verifyDescriptor(ClassDescriptor desc, boolean tableNameShouldStartWithBuilder, String attributeName) {
        String localErrorMsg = "";
        for (String tableName : desc.getTableNames()) {
            boolean startsWithBuilder = tableName.startsWith("BUILDER");
            if (tableNameShouldStartWithBuilder == startsWithBuilder) continue;
            localErrorMsg = localErrorMsg + "Wrong table name " + tableName + "; ";
        }
        if (localErrorMsg.length() > 0) {
            localErrorMsg = "Ref.descriptor class: " + Helper.getShortClassName((Class)desc.getJavaClass()) + "; mapping: " + attributeName + ": " + localErrorMsg + "\n";
        }
        return localErrorMsg;
    }
}

