/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.GolfClub;
import org.eclipse.persistence.testing.models.aggregate.GolfClubShaft;

public class InMemoryQueryKeyToAggregateTest
extends AutoVerifyTestCase {
    protected boolean shouldLoadObjectsIntoMemory = false;
    protected GolfClub club = null;
    protected GolfClub originalClub = null;

    public InMemoryQueryKeyToAggregateTest(boolean shouldLoadObjectsIntoMemory) {
        this.setName("InMemoryQueryKeyToAggregateTest - load into memory = " + shouldLoadObjectsIntoMemory);
        this.setDescription("Ensure that an in-memory query works when a DirectQueryKey that maps to an attribute defined in an attribute works.");
        this.shouldLoadObjectsIntoMemory = shouldLoadObjectsIntoMemory;
    }

    public void setup() {
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(GolfClub.class);
        descriptor.addDirectQueryKey("stiffness", "GOLF_CLUB.SHAFT_STIFFNESS");
        DirectQueryKey key = (DirectQueryKey)descriptor.getQueryKeyNamed("stiffness");
        key.initialize(descriptor);
        this.beginTransaction();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalClub = (GolfClub)uow.registerObject((Object)new GolfClub());
        GolfClubShaft shaft = new GolfClubShaft();
        shaft.setStiffnessRating("R");
        this.originalClub.setShaft(shaft);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        if (this.shouldLoadObjectsIntoMemory) {
            uow.readAllObjects(GolfClub.class);
        }
        ReadObjectQuery query = new ReadObjectQuery(GolfClub.class);
        query.conformResultsInUnitOfWork();
        ExpressionBuilder clubs = new ExpressionBuilder();
        Expression exp = clubs.get("stiffness").equal((Object)"R");
        query.setSelectionCriteria(exp);
        this.club = (GolfClub)uow.executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        if (this.club == null || !this.club.getId().equals(this.originalClub.getId())) {
            throw new TestErrorException("Executing an in-memory query with a query key to an aggregate returns the wrong result.");
        }
    }

    public void reset() {
        this.rollbackTransaction();
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(GolfClub.class);
        descriptor.getQueryKeys().remove("stiffness");
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

