/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalUniqueConstraint;
import org.eclipse.persistence.tools.mapping.orm.dom.UniqueConstraint;
import org.eclipse.persistence.tools.utility.TextRange;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

abstract class Table
extends AbstractExternalForm
implements ExternalEntityTable {
    Table(AbstractExternalForm parent) {
        super(parent);
    }

    @Override
    public ExternalUniqueConstraint addUniqueConstraint(ListIterable<String> columnNames) {
        UniqueConstraint uniqueConstraint = this.buildUniqueConstraint(-1);
        uniqueConstraint.addSelf();
        uniqueConstraint.setColumnNames(columnNames);
        return uniqueConstraint;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("catalog");
        names.add("schema");
        return names;
    }

    private UniqueConstraint buildUniqueConstraint(int index) {
        return new UniqueConstraint(this, index);
    }

    @Override
    public final String getCatalogName() {
        return this.getAttribute("catalog");
    }

    @Override
    public final TextRange getCatalogTextRange() {
        return this.getAttributeTextRange("catalog");
    }

    @Override
    public final String getName() {
        return this.getAttribute("name");
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    @Override
    public final String getSchemaName() {
        return this.getAttribute("schema");
    }

    @Override
    public TextRange getSchemaTextRange() {
        return this.getAttributeTextRange("schema");
    }

    @Override
    public final ExternalUniqueConstraint getUniqueConstraint(int index) {
        if (this.hasChild("unique-constraint", index)) {
            return this.buildUniqueConstraint(index);
        }
        return null;
    }

    @Override
    public final void removeAllUniqueConstraints() {
        this.removeChildren("unique-constraint");
    }

    @Override
    public final void removeUniqueConstraint(int index) {
        UniqueConstraint uniqueConstraint = this.buildUniqueConstraint(index);
        uniqueConstraint.removeSelf();
    }

    @Override
    public final void setCatalogName(String catalog) {
        this.setAttribute("catalog", catalog);
    }

    @Override
    public final void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public final void setSchemaName(String name) {
        this.setAttribute("schema", name);
    }

    @Override
    public final List<ExternalUniqueConstraint> uniqueConstraints() {
        int count = this.uniqueConstraintsSize();
        ArrayList<ExternalUniqueConstraint> uniqueConstraints = new ArrayList<ExternalUniqueConstraint>(count);
        int index = 0;
        while (index < count) {
            uniqueConstraints.add(this.buildUniqueConstraint(index));
            ++index;
        }
        return uniqueConstraints;
    }

    @Override
    public final int uniqueConstraintsSize() {
        return this.getChildrenSize("unique-constraint");
    }
}

