/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.persistence.dom;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.ExternalFormHelper;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceConfiguration;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceUnit;
import org.eclipse.persistence.tools.mapping.persistence.PersistenceDocumentType;
import org.eclipse.persistence.tools.mapping.persistence.dom.PersistenceUnit;
import org.w3c.dom.Element;

public final class PersistenceConfiguration
extends AbstractExternalForm
implements ExternalPersistenceConfiguration {
    private final ExternalFormHelper helper;

    public PersistenceConfiguration(ExternalFormHelper helper) {
        super(null);
        this.helper = helper;
    }

    @Override
    public ExternalPersistenceUnit addPersistenceUnit(String name) {
        PersistenceUnit persistenceUnit = this.buildPersistenceUnit(-1);
        persistenceUnit.addSelf();
        persistenceUnit.setName(name);
        return persistenceUnit;
    }

    @Override
    protected Element addSelf(String elementName) {
        return this.addSelf(elementName, Collections.<String>emptyList());
    }

    @Override
    public Element addSelf(String elementName, List<String> elementNamesOrder) {
        return this.helper.buildPersistenceConfiguration(this);
    }

    private PersistenceUnit buildPersistenceUnit(int index) {
        return new PersistenceUnit(this, index);
    }

    public String buildSchemaLocation(PersistenceDocumentType type) {
        StringBuilder sb = new StringBuilder();
        sb.append("http://java.sun.com/xml/ns/persistence");
        sb.append(" ");
        switch (type) {
            case JPA_1_0: {
                sb.append("http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd");
                break;
            }
            case JPA_2_0: {
                sb.append("http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd");
                break;
            }
            case JPA_2_1: {
                sb.append("http://java.sun.com/xml/ns/persistence/persistence_2_1.xsd");
            }
        }
        return sb.toString();
    }

    @Override
    public String getBuildVersion() {
        return PersistenceDocumentType.JPA_2_1.getVersion();
    }

    @Override
    public PersistenceDocumentType getDocumentType() {
        return PersistenceDocumentType.value(this.getNamespace(), this.getVersion(), this.getSchemaLocation());
    }

    @Override
    public Element getElement() {
        return this.getRootElement();
    }

    @Override
    public String getElementName() {
        return "persistence";
    }

    @Override
    protected ExternalFormHelper getHelper() {
        return this.helper;
    }

    @Override
    public URL getLocation() {
        return this.helper.getLocation();
    }

    @Override
    public ExternalPersistenceUnit getPersistenceUnit(int index) {
        if (this.hasChild("persistence-unit", index)) {
            return this.buildPersistenceUnit(index);
        }
        return null;
    }

    @Override
    public List<ExternalPersistenceUnit> persistenceUnits() {
        int count = this.persistenceUnitsSize();
        ArrayList<ExternalPersistenceUnit> persistenceUnits = new ArrayList<ExternalPersistenceUnit>(count);
        int index = 0;
        while (index < count) {
            persistenceUnits.add(this.buildPersistenceUnit(index));
            ++index;
        }
        return persistenceUnits;
    }

    @Override
    public int persistenceUnitsSize() {
        return this.getChildrenSize("persistence-unit");
    }

    @Override
    public void removePersistenceUnit(int index) {
        PersistenceUnit persistenceUnit = this.buildPersistenceUnit(index);
        persistenceUnit.removeSelf();
    }

    @Override
    public void save() throws Exception {
        this.helper.save();
    }

    @Override
    public void setDocumentType(PersistenceDocumentType type) {
        this.setAttribute("version", type.getVersion());
        this.setSchemaLocation(this.buildSchemaLocation(type));
    }
}

