/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.collection;

import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.collection.LinkedQueue;
import org.eclipse.persistence.tools.utility.collection.Queue;
import org.eclipse.persistence.tools.utility.collection.SynchronizedQueue;
import org.eclipse.persistence.tools.utility.tests.MultiThreadedTestCase;
import org.eclipse.persistence.tools.utility.tests.collection.QueueTests;

public class SynchronizedQueueTests
extends QueueTests {
    private volatile SynchronizedQueue<String> sq;
    volatile boolean timeoutOccurred;
    volatile long startTime;
    volatile long endTime;
    volatile Object dequeuedObject;
    static final String ITEM_1 = new String();
    static final String ITEM_2 = new String();

    public SynchronizedQueueTests(String name) {
        super(name);
    }

    @Override
    Queue<String> buildQueue() {
        return new SynchronizedQueue();
    }

    @Override
    public void testClone() {
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sq = new SynchronizedQueue();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.dequeuedObject = null;
    }

    public void testConcurrentAccess() throws Exception {
        this.verifyConcurrentAccess(new SlowLinkedQueue<String>(), "first");
        this.verifyConcurrentAccess(new SlowSynchronizedQueue<String>(), "second");
    }

    private void verifyConcurrentAccess(SlowQueue<String> slowQueue, String expected) throws Exception {
        slowQueue.enqueue("first");
        slowQueue.enqueue("second");
        Thread thread = this.buildThread(this.buildRunnable(slowQueue));
        thread.start();
        Thread.sleep(TWO_TICKS);
        SynchronizedQueueTests.assertEquals((String)expected, (String)((String)slowQueue.dequeue()));
        thread.join();
        SynchronizedQueueTests.assertTrue((boolean)slowQueue.isEmpty());
    }

    private Runnable buildRunnable(final SlowQueue<String> slowQueue) {
        return new Runnable(){

            @Override
            public void run() {
                slowQueue.slowDequeue();
            }
        };
    }

    public void testWaitToDequeue() throws Exception {
        this.verifyWaitToDequeue(0L);
        SynchronizedQueueTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToDequeueTimeout() throws Exception {
        this.verifyWaitToDequeue(TICK);
        SynchronizedQueueTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertNull((Object)this.dequeuedObject);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.sq.peek());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToDequeue(long timeout) throws Exception {
        Runnable r1 = this.buildRunnable(this.buildEnqueueCommand(), this.sq, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToDequeueCommand(timeout), this.sq, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    public void testWaitToEnqueue() throws Exception {
        this.verifyWaitToEnqueue(0L);
        SynchronizedQueueTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertFalse((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertSame((Object)ITEM_2, (Object)this.sq.peek());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToEnqueueTimeout() throws Exception {
        this.verifyWaitToEnqueue(TICK);
        SynchronizedQueueTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToEnqueue(long timeout) throws Exception {
        this.sq.enqueue((Object)ITEM_1);
        Runnable r1 = this.buildRunnable(this.buildDequeueCommand(), this.sq, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToEnqueueCommand(timeout), this.sq, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildEnqueueCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedQueue<String> synchronizedQueue) {
                synchronizedQueue.enqueue((Object)ITEM_1);
            }
        };
    }

    private Command buildWaitToDequeueCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedQueue<String> synchronizedQueue) throws InterruptedException {
                SynchronizedQueueTests.this.startTime = System.currentTimeMillis();
                try {
                    SynchronizedQueueTests.this.dequeuedObject = synchronizedQueue.waitToDequeue(timeout);
                }
                catch (NoSuchElementException noSuchElementException) {
                    SynchronizedQueueTests.this.timeoutOccurred = true;
                }
                SynchronizedQueueTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Command buildDequeueCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedQueue<String> synchronizedQueue) {
                SynchronizedQueueTests.this.dequeuedObject = synchronizedQueue.dequeue();
            }
        };
    }

    private Command buildWaitToEnqueueCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedQueue<String> synchronizedQueue) throws InterruptedException {
                SynchronizedQueueTests.this.startTime = System.currentTimeMillis();
                SynchronizedQueueTests.this.timeoutOccurred = !synchronizedQueue.waitToEnqueue((Object)ITEM_2, timeout);
                SynchronizedQueueTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedQueue<String> synchronizedQueue, final long sleep) {
        return new MultiThreadedTestCase.TestRunnable(this){

            @Override
            protected void run_() throws Throwable {
                if (sleep != 0L) {
                    Thread.sleep(sleep);
                }
                command.execute((SynchronizedQueue<String>)synchronizedQueue);
            }
        };
    }

    long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    private static interface Command {
        public void execute(SynchronizedQueue<String> var1) throws InterruptedException;
    }

    private class SlowLinkedQueue<E>
    extends LinkedQueue<E>
    implements SlowQueue<E> {
        private static final long serialVersionUID = 1L;

        SlowLinkedQueue() {
        }

        @Override
        public Object slowDequeue() {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return this.dequeue();
        }
    }

    private static interface SlowQueue<E>
    extends Queue<E> {
        public Object slowDequeue();
    }

    private class SlowSynchronizedQueue<E>
    extends SynchronizedQueue<E>
    implements SlowQueue<E> {
        private static final long serialVersionUID = 1L;

        SlowSynchronizedQueue() {
        }

        @Override
        public synchronized Object slowDequeue() {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return this.dequeue();
        }
    }
}

