/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.collection.Queue;

public class ArrayQueue<E>
implements Queue<E>,
Cloneable,
Serializable {
    private transient E[] elements;
    private transient int head = 0;
    private transient int tail = 0;
    private int size = 0;
    private static final long serialVersionUID = 1L;

    public ArrayQueue() {
        this(10);
    }

    public ArrayQueue(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + initialCapacity);
        }
        this.elements = new Object[initialCapacity];
    }

    public ArrayQueue(Collection<? extends E> c) {
        this.size = c.size();
        int capacity = (int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE);
        this.elements = c.toArray(new Object[capacity]);
    }

    @Override
    public void enqueue(E element) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.tail] = element;
        if (++this.tail == this.elements.length) {
            this.tail = 0;
        }
        ++this.size;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (oldCapacity < minCapacity) {
            int newCapacity = (oldCapacity * 3 >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elements = this.copyElements(newCapacity);
            this.head = 0;
            this.tail = this.size;
        }
    }

    public void trimToSize() {
        if (this.elements.length > this.size) {
            this.elements = this.copyElements(this.size);
            this.head = 0;
            this.tail = this.size;
        }
    }

    private E[] copyElements(int newCapacity) {
        Object[] newElements = new Object[newCapacity];
        if (this.size != 0) {
            E[] oldElements = this.elements;
            if (this.head == 0 || this.head < this.tail || this.tail == 0) {
                System.arraycopy(oldElements, this.head, newElements, 0, this.size);
            } else {
                int fragmentSize = oldElements.length - this.head;
                System.arraycopy(oldElements, this.head, newElements, 0, fragmentSize);
                System.arraycopy(oldElements, 0, newElements, fragmentSize, this.size - fragmentSize);
            }
        }
        return newElements;
    }

    @Override
    public E dequeue() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        E element = this.elements[this.head];
        this.elements[this.head] = null;
        if (++this.head == this.elements.length) {
            this.head = 0;
        }
        --this.size;
        return element;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[this.head];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public ArrayQueue<E> clone() {
        try {
            ArrayQueue clone = (ArrayQueue)super.clone();
            Object[] array = (Object[])this.elements.clone();
            clone.elements = array;
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return Arrays.toString(this.copyElements(this.size));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        block4: {
            int elementsLength;
            E[] array;
            block3: {
                stream.defaultWriteObject();
                array = this.elements;
                elementsLength = array.length;
                stream.writeInt(elementsLength);
                if (this.head >= this.tail) break block3;
                int i = this.head;
                while (i < this.tail) {
                    stream.writeObject(array[i]);
                    ++i;
                }
                break block4;
            }
            if (this.head <= this.tail) break block4;
            int i = this.head;
            while (i < elementsLength) {
                stream.writeObject(array[i]);
                ++i;
            }
            i = 0;
            while (i < this.tail) {
                stream.writeObject(array[i]);
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementsLength = stream.readInt();
        Object[] array = new Object[elementsLength];
        int i = 0;
        while (i < this.size) {
            array[i] = stream.readObject();
            ++i;
        }
        this.elements = array;
        this.head = 0;
        this.tail = this.size;
    }
}

