/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import java.util.concurrent.ThreadFactory;
import org.eclipse.persistence.tools.utility.ConsumerThreadCoordinator;
import org.eclipse.persistence.tools.utility.ExceptionHandler;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.SimpleThreadFactory;
import org.eclipse.persistence.tools.utility.collection.SynchronizedQueue;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.StatefulCommandExecutor;

public abstract class AbstractAsynchronousCommandExecutor<E extends StatefulCommandExecutor>
implements StatefulCommandExecutor {
    protected final E commandExecutor;
    private final SynchronizedQueue<Command> commands = new SynchronizedQueue();
    private final ConsumerThreadCoordinator consumerThreadCoordinator;

    protected AbstractAsynchronousCommandExecutor(Config<E> config) {
        this(config.getCommandExecutor(), config.getThreadFactory(), config.getThreadName(), config.getExceptionHandler());
    }

    protected AbstractAsynchronousCommandExecutor(E commandExecutor, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
        if (commandExecutor == null) {
            throw new NullPointerException();
        }
        this.commandExecutor = commandExecutor;
        this.consumerThreadCoordinator = this.buildConsumerThreadCoordinator(threadFactory, threadName, exceptionHandler);
    }

    private ConsumerThreadCoordinator buildConsumerThreadCoordinator(ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
        return new ConsumerThreadCoordinator(this.buildConsumer(), threadFactory, threadName, exceptionHandler);
    }

    private ConsumerThreadCoordinator.Consumer buildConsumer() {
        return new Consumer();
    }

    @Override
    public synchronized void start() {
        this.commandExecutor.start();
        this.consumerThreadCoordinator.start();
    }

    @Override
    public synchronized void execute(Command command) {
        this.commands.enqueue(command);
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        this.consumerThreadCoordinator.stop();
        this.commandExecutor.stop();
    }

    void waitForCommand() throws InterruptedException {
        this.commands.waitUntilNotEmpty();
    }

    void executeNextCommand() {
        this.commandExecutor.execute(this.commands.dequeue());
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.commands);
    }

    public static interface Config<E extends StatefulCommandExecutor> {
        public E getCommandExecutor();

        public ThreadFactory getThreadFactory();

        public String getThreadName();

        public ExceptionHandler getExceptionHandler();
    }

    class Consumer
    implements ConsumerThreadCoordinator.Consumer {
        Consumer() {
        }

        @Override
        public void waitForProducer() throws InterruptedException {
            AbstractAsynchronousCommandExecutor.this.waitForCommand();
        }

        @Override
        public void consume() {
            AbstractAsynchronousCommandExecutor.this.executeNextCommand();
        }
    }

    protected static abstract class SimpleConfig<E extends StatefulCommandExecutor>
    implements Config<E> {
        private volatile E commandExecutor;
        private volatile ThreadFactory threadFactory;
        private volatile String threadName;
        private volatile ExceptionHandler exceptionHandler;

        protected SimpleConfig() {
            this.commandExecutor = this.buildDefaultCommandExecutor();
            this.threadFactory = this.buildDefaultThreadFactory();
            this.threadName = this.buildDefaultThreadName();
            this.exceptionHandler = this.buildDefaultExceptionHandler();
        }

        protected SimpleConfig(E commandExecutor, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
            this.commandExecutor = commandExecutor;
            this.threadFactory = threadFactory;
            this.threadName = threadName;
            this.exceptionHandler = exceptionHandler;
        }

        public void setCommandExecutor(E commandExecutor) {
            this.commandExecutor = commandExecutor;
        }

        @Override
        public E getCommandExecutor() {
            return this.commandExecutor;
        }

        protected abstract E buildDefaultCommandExecutor();

        public void setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        protected ThreadFactory buildDefaultThreadFactory() {
            return SimpleThreadFactory.instance();
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public String getThreadName() {
            return this.threadName;
        }

        protected String buildDefaultThreadName() {
            return null;
        }

        public void setExceptionHandler(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public ExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        protected ExceptionHandler buildDefaultExceptionHandler() {
            return ExceptionHandler.Runtime.instance();
        }
    }
}

