/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.filter;

import java.io.Serializable;
import org.eclipse.persistence.tools.utility.ObjectTools;

public interface Filter<T> {
    public boolean accept(T var1);

    public static class Adapter<S>
    implements Filter<S> {
        @Override
        public boolean accept(S o) {
            return true;
        }

        public String toString() {
            return ObjectTools.toString(this);
        }
    }

    public static final class Disabled<S>
    implements Filter<S>,
    Serializable {
        public static final Filter INSTANCE = new Disabled();
        private static final long serialVersionUID = 1L;

        public static <R> Filter<R> instance() {
            return INSTANCE;
        }

        private Disabled() {
        }

        @Override
        public boolean accept(S o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Opaque<S>
    implements Filter<S>,
    Serializable {
        public static final Filter INSTANCE = new Opaque();
        private static final long serialVersionUID = 1L;

        public static <R> Filter<R> instance() {
            return INSTANCE;
        }

        private Opaque() {
        }

        @Override
        public boolean accept(S o) {
            return false;
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Transparent<S>
    implements Filter<S>,
    Serializable {
        public static final Filter INSTANCE = new Transparent();
        private static final long serialVersionUID = 1L;

        public static <R> Filter<R> instance() {
            return INSTANCE;
        }

        private Transparent() {
        }

        @Override
        public boolean accept(S o) {
            return true;
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

