/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.event;

import java.util.Collection;
import org.eclipse.persistence.tools.utility.StringBuilderTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;
import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.event.CollectionEvent;

public final class CollectionRemoveEvent
extends CollectionEvent {
    private final Object[] items;
    private static final long serialVersionUID = 1L;

    public CollectionRemoveEvent(Model source, String collectionName, Object item) {
        this(source, collectionName, new Object[]{item});
    }

    public CollectionRemoveEvent(Model source, String collectionName, Collection<?> items) {
        this(source, collectionName, items.toArray());
    }

    private CollectionRemoveEvent(Model source, String collectionName, Object[] items) {
        super(source, collectionName);
        this.items = items;
    }

    public Iterable<?> getItems() {
        return new ArrayIterable<Object>(this.items);
    }

    public int getItemsSize() {
        return this.items.length;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(": ");
        StringBuilderTools.append(sb, this.items);
    }

    public CollectionRemoveEvent clone(Model newSource) {
        return this.clone(newSource, this.collectionName);
    }

    public CollectionRemoveEvent clone(Model newSource, String newCollectionName) {
        return new CollectionRemoveEvent(newSource, newCollectionName, this.items);
    }
}

