/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.StringMatcher;
import org.eclipse.persistence.tools.utility.swing.SimpleListCellRenderer;
import org.eclipse.persistence.tools.utility.transformer.StringObjectTransformer;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public class FilteringListPanel<T>
extends JPanel {
    private T[] completeList;
    Transformer<T, String> transformer;
    private JTextField textField;
    private JLabel textFieldLabel;
    private DocumentListener textFieldListener;
    private JList listBox;
    private JLabel listBoxLabel;
    private int maxListSize;
    private Object[] buffer;
    private static final Border TEXT_FIELD_LABEL_BORDER = BorderFactory.createEmptyBorder(0, 0, 5, 0);
    private static final Border LIST_BOX_LABEL_BORDER = BorderFactory.createEmptyBorder(5, 0, 5, 0);
    private static final long serialVersionUID = 1L;
    private static final String ALL = "*";

    public FilteringListPanel(T[] completeList, T initialSelection) {
        this(completeList, initialSelection, StringObjectTransformer.instance());
    }

    public FilteringListPanel(T[] completeList, T initialSelection, Transformer<T, String> stringConverter) {
        super(new BorderLayout());
        this.completeList = completeList;
        this.transformer = stringConverter;
        this.initialize(initialSelection);
    }

    private void initialize(T initialSelection) {
        this.maxListSize = this.getDefaultMaxListSize();
        this.buffer = this.buildBuffer();
        this.textFieldListener = this.buildTextFieldListener();
        this.initializeLayout(initialSelection);
    }

    private Object[] buildBuffer() {
        return new Object[this.getMax()];
    }

    private int getMax() {
        return this.maxListSize == -1 ? this.completeList.length : Math.min(this.maxListSize, this.completeList.length);
    }

    private DocumentListener buildTextFieldListener() {
        return new TextFieldListener();
    }

    private int getDefaultMaxListSize() {
        return -1;
    }

    private void initializeLayout(Object initialSelection) {
        JPanel textFieldPanel = new JPanel(new BorderLayout());
        this.textFieldLabel = new JLabel();
        this.textFieldLabel.setBorder(TEXT_FIELD_LABEL_BORDER);
        textFieldPanel.add((Component)this.textFieldLabel, "North");
        this.textField = new JTextField();
        this.textField.getDocument().addDocumentListener(this.textFieldListener);
        this.textFieldLabel.setLabelFor(this.textField);
        textFieldPanel.add((Component)this.textField, "Center");
        this.add((Component)textFieldPanel, "North");
        JPanel listBoxPanel = new JPanel(new BorderLayout());
        this.listBoxLabel = new JLabel();
        this.listBoxLabel.setBorder(LIST_BOX_LABEL_BORDER);
        listBoxPanel.add((Component)this.listBoxLabel, "North");
        this.listBox = new JList();
        this.listBox.setDoubleBuffered(true);
        this.listBox.setModel(this.buildPartialArrayListModel(this.completeList, this.getMax()));
        this.listBox.getSelectionModel().setSelectionMode(0);
        this.listBox.setPrototypeCellValue(this.getPrototypeCellValue());
        this.listBox.setPrototypeCellValue(null);
        this.listBox.setCellRenderer(this.buildDefaultCellRenderer());
        this.listBoxLabel.setLabelFor(this.listBox);
        JScrollPane listBoxScrollPane = new JScrollPane(this.listBox);
        listBoxScrollPane.getHorizontalScrollBar().setFocusable(false);
        listBoxScrollPane.getVerticalScrollBar().setFocusable(false);
        listBoxPanel.add((Component)listBoxScrollPane, "Center");
        this.listBox.setSelectedValue(initialSelection, true);
        this.textField.select(0, this.textField.getText().length());
        this.add((Component)listBoxPanel, "Center");
    }

    public Object getSelection() {
        return this.listBox.getSelectedValue();
    }

    public void setSelection(Object selection) {
        this.listBox.setSelectedValue(selection, true);
    }

    public T[] getCompleteList() {
        return this.completeList;
    }

    public void setCompleteList(T[] completeList) {
        this.completeList = completeList;
        if (this.buffer.length < this.getMax()) {
            this.buffer = this.buildBuffer();
        }
        this.filterList();
    }

    public int getMaxListSize() {
        return this.maxListSize;
    }

    public void setMaxListSize(int maxListSize) {
        this.maxListSize = maxListSize;
        if (this.buffer.length < this.getMax()) {
            this.buffer = this.buildBuffer();
        }
        this.filterList();
    }

    public Transformer<T, String> getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer<T, String> transformer) {
        this.transformer = transformer;
        this.filterList();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JLabel getTextFieldLabel() {
        return this.textFieldLabel;
    }

    public void setTextFieldLabelText(String text) {
        this.textFieldLabel.setText(text);
    }

    public JList getListBox() {
        return this.listBox;
    }

    public void setListBoxCellRenderer(ListCellRenderer renderer) {
        this.listBox.setCellRenderer(renderer);
    }

    public JLabel getListBoxLabel() {
        return this.listBoxLabel;
    }

    public void setListBoxLabelText(String text) {
        this.listBoxLabel.setText(text);
    }

    public void setComponentsFont(Font font) {
        this.textFieldLabel.setFont(font);
        this.textField.setFont(font);
        this.listBoxLabel.setFont(font);
        this.listBox.setFont(font);
    }

    protected String getPrototypeCellValue() {
        return "==========> A_STRING_THAT_IS_DEFINITELY_LONGER_THAN_EVERY_STRING_IN_THE_LIST <==========";
    }

    protected ListCellRenderer buildDefaultCellRenderer() {
        return new DefaultCellRenderer();
    }

    synchronized void filterList() {
        this.filterList(this.textField.getText());
    }

    private void filterList(String pattern) {
        if (pattern.length() == 0) {
            this.listBox.setModel(this.buildPartialArrayListModel(this.completeList, this.getMax()));
        } else {
            StringMatcher stringMatcher = new StringMatcher(String.valueOf(pattern) + ALL, true, false);
            int j = 0;
            int len = this.completeList.length;
            int max = this.getMax();
            int i = 0;
            while (i < len) {
                if (stringMatcher.match(this.transformer.transform(this.completeList[i]))) {
                    this.buffer[j++] = this.completeList[i];
                }
                if (j == max) break;
                ++i;
            }
            this.listBox.setModel(this.buildPartialArrayListModel(this.buffer, j));
        }
        if (this.listBox.getModel().getSize() == 0) {
            this.listBox.getSelectionModel().clearSelection();
        } else {
            this.listBox.getSelectionModel().setAnchorSelectionIndex(0);
            this.listBox.getSelectionModel().setLeadSelectionIndex(0);
            this.listBox.ensureIndexIsVisible(0);
        }
    }

    private ListModel buildPartialArrayListModel(Object[] array, int size) {
        return new PartialArrayListModel(array, size);
    }

    protected class DefaultCellRenderer
    extends SimpleListCellRenderer {
        private static final long serialVersionUID = 1L;

        protected DefaultCellRenderer() {
        }

        @Override
        protected String buildText(Object value) {
            return FilteringListPanel.this.transformer.transform(value);
        }
    }

    static class PartialArrayListModel<T>
    extends AbstractListModel {
        private final Object[] array;
        private final int size;
        private static final long serialVersionUID = 1L;

        PartialArrayListModel(Object[] array, int size) {
            this.array = array;
            this.size = size;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public T getElementAt(int index) {
            return (T)this.array[index];
        }
    }

    class TextFieldListener
    implements DocumentListener {
        TextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FilteringListPanel.this.filterList();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            FilteringListPanel.this.filterList();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FilteringListPanel.this.filterList();
        }

        public String toString() {
            return ObjectTools.toString(this);
        }
    }
}

