/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.annotations.ExistenceType;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalCache;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityListener;
import org.eclipse.persistence.tools.mapping.orm.ExternalFetchGroup;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappedSuperClass;
import org.eclipse.persistence.tools.mapping.orm.ExternalMultitenancyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalNativeQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.ExternalOptimisticLocking;
import org.eclipse.persistence.tools.mapping.orm.ExternalPrimaryKey;
import org.eclipse.persistence.tools.mapping.orm.ExternalSequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.EmbeddableTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.ORMConfigurationTests;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.w3c.dom.Node;

public class MappedSuperclassTests<T extends ExternalMappedSuperClass>
extends EmbeddableTests<T> {
    final String buildAdditionalCriteriaTester() {
        return "additional-criteria";
    }

    final AbstractExternalFormTests.AttributeNodeTester<T, Boolean> buildCacheableTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<T, Boolean>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public Boolean getDefaultValue() {
                return Boolean.TRUE;
            }

            @Override
            public String getNodeName() {
                return "cacheable";
            }

            @Override
            public Boolean getValue(T form) {
                return form.isCacheable();
            }

            @Override
            public Boolean getValue1() {
                return Boolean.TRUE;
            }

            @Override
            public Boolean getValue2() {
                return Boolean.FALSE;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, Boolean value) {
                form.setCacheable(value);
            }

            @Override
            public String toString(Boolean value) {
                return value.toString();
            }
        };
    }

    final String buildCacheIndexTester() {
        return "cache-index";
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, String> buildCacheInterceptorTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "cache-interceptor";
            }

            @Override
            public String getDefaultValue() {
                return "org.test.CacheInterceptor";
            }

            @Override
            public String getNodeName() {
                return "class";
            }

            @Override
            public String getValue(T form) {
                return form.getCacheInterceptorClassName();
            }

            @Override
            public String getValue1() {
                return "org.test.MainCacheInterceptor";
            }

            @Override
            public String getValue2() {
                return "org.test.AnotherCacheInterceptor";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setCacheInterceptorClassName(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.ChildNodeTester<T, ExternalCache> buildCacheTester() {
        return new AbstractExternalFormTests.ChildNodeTester<T, ExternalCache>(){

            @Override
            public ExternalCache addChild(T form) {
                return form.addCache();
            }

            @Override
            public ExternalCache getChild(T form) {
                return form.getCache();
            }

            @Override
            public String getNodeName() {
                return "cache";
            }

            @Override
            public boolean hasChild(T form) {
                return form.hasCache();
            }

            @Override
            public void removeChild(T form) {
                form.removeCache();
            }
        };
    }

    final AbstractExternalFormTests.ContainerChildListNodeTester<T, ExternalEntityListener, String> buildEntityListenersTester() {
        return new AbstractExternalFormTests.ContainerChildListNodeTester<T, ExternalEntityListener, String>(){

            @Override
            public ExternalEntityListener addChild(T form, String value) {
                return form.addEntityListener(value);
            }

            @Override
            public ExternalEntityListener getChild(T form, int index) {
                return form.getEntityListener(index);
            }

            @Override
            public ExternalEntityListener getChildForm(List<ExternalEntityListener> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalEntityListener> getChildren(T form) {
                return form.entityListeners();
            }

            @Override
            public int getChildrenSize(T form) {
                return form.entityListenersSize();
            }

            @Override
            public String getChildValue(ExternalEntityListener childForm) {
                return childForm.getClassName();
            }

            @Override
            public String getContainerNodeName() {
                return "entity-listeners";
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "ENTITY_LISTENER_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "entity-listener";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(T form, int index) {
                form.removeEntityListener(index);
            }
        };
    }

    final AbstractExternalFormTests.BooleanChildNodeTester<T> buildExcludeDefaultListenersTester() {
        return new AbstractExternalFormTests.BooleanChildNodeTester<T>(){

            @Override
            public String getNodeName() {
                return "exclude-default-listeners";
            }

            @Override
            public boolean getValue(T form) {
                return form.shouldExcludesDefaultListeners();
            }

            @Override
            public void setValue(T form, boolean value) {
                form.setExcludesDefaultListeners(value);
            }
        };
    }

    final AbstractExternalFormTests.AttributeNodeTester<T, Boolean> buildExcludeDefaultMappingsTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<T, Boolean>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public Boolean getDefaultValue() {
                return Boolean.TRUE;
            }

            @Override
            public String getNodeName() {
                return "exclude-default-mappings";
            }

            @Override
            public Boolean getValue(T form) {
                return form.isExcludeDefaultMappings();
            }

            @Override
            public Boolean getValue1() {
                return Boolean.TRUE;
            }

            @Override
            public Boolean getValue2() {
                return Boolean.FALSE;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, Boolean value) {
                form.setExcludeDefaultMappings(value);
            }

            @Override
            public String toString(Boolean value) {
                return value.toString();
            }
        };
    }

    final AbstractExternalFormTests.BooleanChildNodeTester<T> buildExcludeSuperclassListenersTester() {
        return new AbstractExternalFormTests.BooleanChildNodeTester<T>(){

            @Override
            public String getNodeName() {
                return "exclude-superclass-listeners";
            }

            @Override
            public boolean getValue(T form) {
                return form.shouldExcludesSuperclassListeners();
            }

            @Override
            public void setValue(T form, boolean value) {
                form.setExcludesSuperclassListeners(value);
            }
        };
    }

    final AbstractExternalFormTests.AttributeNodeTester<T, ExistenceType> buildExistenceCheckingTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<T, ExistenceType>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public ExistenceType getDefaultValue() {
                return ExistenceType.CHECK_DATABASE;
            }

            @Override
            public String getNodeName() {
                return "existence-checking";
            }

            @Override
            public ExistenceType getValue(T form) {
                return form.getExistenceCheckingType();
            }

            @Override
            public ExistenceType getValue1() {
                return ExistenceType.ASSUME_NON_EXISTENCE;
            }

            @Override
            public ExistenceType getValue2() {
                return ExistenceType.CHECK_CACHE;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, ExistenceType value) {
                form.setExistenceCheckingType(value);
            }

            @Override
            public String toString(ExistenceType value) {
                return value.toString();
            }
        };
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalFetchGroup, String> buildFetchGroupTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<T, ExternalFetchGroup, String>(){

            @Override
            public ExternalFetchGroup addChild(T form, String value) {
                return form.addFetchGroup(value);
            }

            @Override
            public ExternalFetchGroup getChild(T form, int index) {
                return form.getFetchGroup(index);
            }

            @Override
            public ExternalFetchGroup getChildForm(List<ExternalFetchGroup> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalFetchGroup> getChildren(T form) {
                return form.fetchGroups();
            }

            @Override
            public int getChildrenSize(T form) {
                return form.fetchGroupsSize();
            }

            @Override
            public String getChildValue(ExternalFetchGroup childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "FETCH_GROUP_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "fetch-group";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(T form, int index) {
                form.removeFetchGroup(index);
            }
        };
    }

    final String buildHashPartitioningTester() {
        return "hash-partitioning";
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, String> buildIdClassTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "id-class";
            }

            @Override
            public String getDefaultValue() {
                return "org.test.IDClass";
            }

            @Override
            public String getNodeName() {
                return "class";
            }

            @Override
            public String getValue(T form) {
                return form.getIdClassName();
            }

            @Override
            public String getValue1() {
                return "org.test.IDClass_1";
            }

            @Override
            public String getValue2() {
                return "org.test.IDClass_2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setIdClassName(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    private AbstractExternalFormTests.ExternalFormBuilder<T> buildMappedSuperclassBuilder() {
        return new AbstractExternalFormTests.ExternalFormBuilder<T>(){

            @Override
            public T buildExternalForm() throws IOException {
                ORMConfiguration orm = ORMConfigurationTests.buildExternalForm();
                return orm.addMappedSuperClass(MappedSuperclassTests.this.defaultClassName());
            }

            @Override
            public T buildExternalForm(ExternalForm parentForm) {
                return ((ExternalORMConfiguration)parentForm).addMappedSuperClass(MappedSuperclassTests.this.defaultClassName());
            }

            @Override
            public int getDefaultAttributeCount() {
                return 1;
            }

            @Override
            public Node getNode(T form) {
                return (Node)ObjectTools.execute(form, (String)"getElement");
            }

            @Override
            public String getNodeName() {
                return "mapped-superclass";
            }

            @Override
            public List<String> getTreeNodeNames() {
                return ListTools.list((Object[])new String[]{"entity-mappings", "mapped-superclass"});
            }
        };
    }

    final AbstractExternalFormTests.ChildNodeTester<T, ExternalMultitenancyPolicy> buildMultitenantTester() {
        return new AbstractExternalFormTests.ChildNodeTester<T, ExternalMultitenancyPolicy>(){

            @Override
            public ExternalMultitenancyPolicy addChild(T form) {
                return form.addMultitenancy();
            }

            @Override
            public ExternalMultitenancyPolicy getChild(T form) {
                return form.getMultitenancy();
            }

            @Override
            public String getNodeName() {
                return "multitenant";
            }

            @Override
            public boolean hasChild(T form) {
                return form.hasMultitenancy();
            }

            @Override
            public void removeChild(T form) {
                form.removeMultiTenancy();
            }
        };
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalNativeQuery, String> buildNamedNativeQueryTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<T, ExternalNativeQuery, String>(){

            @Override
            public ExternalNativeQuery addChild(T form, String value) {
                return form.addNativeQuery(value);
            }

            @Override
            public ExternalNativeQuery getChild(T form, int index) {
                return form.getNativeQuery(index);
            }

            @Override
            public ExternalNativeQuery getChildForm(List<ExternalNativeQuery> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalNativeQuery> getChildren(T form) {
                return form.nativeQueries();
            }

            @Override
            public int getChildrenSize(T form) {
                return form.nativeQueriesSize();
            }

            @Override
            public String getChildValue(ExternalNativeQuery childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "NAMED_NATIVE_QUERY_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "named-native-query";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(T form, int index) {
                form.removeNativeQuery(index);
            }
        };
    }

    final String buildNamedPlsqlStoredFunctionQueryTester() {
        return "named-plsql-stored-function-query";
    }

    final String buildNamedPlsqlStoredProcedureQueryTester() {
        return "named-plsql-stored-procedure-query";
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalNamedQuery, String> buildNamedQueryTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<T, ExternalNamedQuery, String>(){

            @Override
            public ExternalNamedQuery addChild(T form, String value) {
                return form.addNamedQuery(value);
            }

            @Override
            public ExternalNamedQuery getChild(T form, int index) {
                return form.getNamedQuery(index);
            }

            @Override
            public ExternalNamedQuery getChildForm(List<ExternalNamedQuery> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalNamedQuery> getChildren(T form) {
                return form.namedQueries();
            }

            @Override
            public int getChildrenSize(T form) {
                return form.namedQueriesSize();
            }

            @Override
            public String getChildValue(ExternalNamedQuery childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "NAMED_QUERY_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "named-query";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(T form, int index) {
                form.removeNamedQuery(index);
            }
        };
    }

    final String buildNamedStoredFunctionQueryTester() {
        return "named-stored-function-query";
    }

    final AbstractExternalFormTests.ChildListNodeTester<T, ExternalNamedStoredProcedureQuery, String> buildNamedStoredProcedureQueryTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<T, ExternalNamedStoredProcedureQuery, String>(){

            @Override
            public ExternalNamedStoredProcedureQuery addChild(T form, String value) {
                return form.addStoredProcedureQuery(value);
            }

            @Override
            public ExternalNamedStoredProcedureQuery getChild(T form, int index) {
                return form.getStoredProcedureQuery(index);
            }

            @Override
            public ExternalNamedStoredProcedureQuery getChildForm(List<ExternalNamedStoredProcedureQuery> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalNamedStoredProcedureQuery> getChildren(T form) {
                return form.storedProcedureQueries();
            }

            @Override
            public int getChildrenSize(T form) {
                return form.storedProcedureQueriesSize();
            }

            @Override
            public String getChildValue(ExternalNamedStoredProcedureQuery childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "NAMED_STORED_PROCEDURE_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "named-stored-procedure-query";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(T form, int index) {
                form.removeStoredProcedureQuery(index);
            }
        };
    }

    final AbstractExternalFormTests.ChildNodeTester<T, ExternalOptimisticLocking> buildOptimisticLockingTester() {
        return new AbstractExternalFormTests.ChildNodeTester<T, ExternalOptimisticLocking>(){

            @Override
            public ExternalOptimisticLocking addChild(T form) {
                return form.addOptimisticLocking();
            }

            @Override
            public ExternalOptimisticLocking getChild(T form) {
                return form.getOptimisticLocking();
            }

            @Override
            public String getNodeName() {
                return "optimistic-locking";
            }

            @Override
            public boolean hasChild(T form) {
                return form.hasOptimisticLocking();
            }

            @Override
            public void removeChild(T form) {
                form.removeOptimisticLocking();
            }
        };
    }

    final String buildPartitionedTester() {
        return "partitioned";
    }

    final String buildPartitioningTester() {
        return "partitioning";
    }

    final String buildPinnedPartitioningTester() {
        return "pinned-partitioning";
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, String> buildPostLoadClassTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "post-load";
            }

            @Override
            public String getDefaultValue() {
                return "postLoad";
            }

            @Override
            public String getNodeName() {
                return "method-name";
            }

            @Override
            public String getValue(T form) {
                return form.getPostLoadMethod();
            }

            @Override
            public String getValue1() {
                return "postLoadMethod1";
            }

            @Override
            public String getValue2() {
                return "postLoadMethod2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setPostLoadMethod(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, String> buildPostPersistClassTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "post-persist";
            }

            @Override
            public String getDefaultValue() {
                return "postPersist";
            }

            @Override
            public String getNodeName() {
                return "method-name";
            }

            @Override
            public String getValue(T form) {
                return form.getPostPersistMethod();
            }

            @Override
            public String getValue1() {
                return "postPersistMethod1";
            }

            @Override
            public String getValue2() {
                return "postPersistMethod2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setPostPersistMethod(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, String> buildPostRemoveClassTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "post-remove";
            }

            @Override
            public String getDefaultValue() {
                return "postRemove";
            }

            @Override
            public String getNodeName() {
                return "method-name";
            }

            @Override
            public String getValue(T form) {
                return form.getPostRemoveMethod();
            }

            @Override
            public String getValue1() {
                return "postRemoveMethod1";
            }

            @Override
            public String getValue2() {
                return "postRemoveMethod2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setPostRemoveMethod(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, String> buildPostUpdateClassTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "post-update";
            }

            @Override
            public String getDefaultValue() {
                return "postRemove";
            }

            @Override
            public String getNodeName() {
                return "method-name";
            }

            @Override
            public String getValue(T form) {
                return form.getPostUpdateMethod();
            }

            @Override
            public String getValue1() {
                return "postRemoveMethod1";
            }

            @Override
            public String getValue2() {
                return "postRemoveMethod2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setPostUpdateMethod(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, String> buildPrePersistClassTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "pre-persist";
            }

            @Override
            public String getDefaultValue() {
                return "prePersist";
            }

            @Override
            public String getNodeName() {
                return "method-name";
            }

            @Override
            public String getValue(T form) {
                return form.getPrePersistMethod();
            }

            @Override
            public String getValue1() {
                return "prePersistMethod1";
            }

            @Override
            public String getValue2() {
                return "prePersistMethod2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setPrePersistMethod(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, String> buildPreRemoveClassTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "pre-remove";
            }

            @Override
            public String getDefaultValue() {
                return "preRemove";
            }

            @Override
            public String getNodeName() {
                return "method-name";
            }

            @Override
            public String getValue(T form) {
                return form.getPreRemoveMethod();
            }

            @Override
            public String getValue1() {
                return "preRemoveMethod1";
            }

            @Override
            public String getValue2() {
                return "preRemoveMethod2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setPreRemoveMethod(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.ChildAttributeTester<T, String> buildPreUpdateClassTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "pre-update";
            }

            @Override
            public String getDefaultValue() {
                return "preUpdate";
            }

            @Override
            public String getNodeName() {
                return "method-name";
            }

            @Override
            public String getValue(T form) {
                return form.getPreUpdateMethod();
            }

            @Override
            public String getValue1() {
                return "preUpdateMethod1";
            }

            @Override
            public String getValue2() {
                return "preUpdateMethod2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setPreUpdateMethod(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    final AbstractExternalFormTests.ChildNodeTester<T, ExternalPrimaryKey> buildPrimaryKeyTester() {
        return new AbstractExternalFormTests.ChildNodeTester<T, ExternalPrimaryKey>(){

            @Override
            public ExternalPrimaryKey addChild(T form) {
                return form.addPrimaryKey();
            }

            @Override
            public ExternalPrimaryKey getChild(T form) {
                return form.getPrimaryKey();
            }

            @Override
            public String getNodeName() {
                return "primary-key";
            }

            @Override
            public boolean hasChild(T form) {
                return form.hasPrimaryKey();
            }

            @Override
            public void removeChild(T form) {
                form.removePrimaryKey();
            }
        };
    }

    final String buildQueryRedirectorsTester() {
        return "query-redirectors";
    }

    final String buildRangePartitioningTester() {
        return "range-partitioning";
    }

    final AbstractExternalFormTests.AttributeNodeTester<T, Boolean> buildReadOnlyTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<T, Boolean>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public Boolean getDefaultValue() {
                return Boolean.TRUE;
            }

            @Override
            public String getNodeName() {
                return "read-only";
            }

            @Override
            public Boolean getValue(T form) {
                return form.isReadOnly();
            }

            @Override
            public Boolean getValue1() {
                return Boolean.TRUE;
            }

            @Override
            public Boolean getValue2() {
                return Boolean.FALSE;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, Boolean value) {
                form.setReadOnly(value);
            }

            @Override
            public String toString(Boolean value) {
                return value.toString();
            }
        };
    }

    final String buildReplicationPartitioningTester() {
        return "replication-partitioning";
    }

    final String buildRoundRobinPartitioningTester() {
        return "round-robin-partitioning";
    }

    final AbstractExternalFormTests.ChildNodeTester<T, ExternalSequenceGenerator> buildSequenceGeneratorTester() {
        return new AbstractExternalFormTests.ChildNodeTester<T, ExternalSequenceGenerator>(){

            @Override
            public ExternalSequenceGenerator addChild(T form) {
                return form.addSequenceGenerator();
            }

            @Override
            public ExternalSequenceGenerator getChild(T form) {
                return form.getSequenceGenerator();
            }

            @Override
            public String getNodeName() {
                return "sequence-generator";
            }

            @Override
            public boolean hasChild(T form) {
                return form.hasSequenceGenerator();
            }

            @Override
            public void removeChild(T form) {
                form.removeSequenceGenerator();
            }
        };
    }

    final String buildSerializedObjectTester() {
        return "serialized-object";
    }

    final String buildSqlResultSetMappingTester() {
        return "sql-result-set-mapping";
    }

    final AbstractExternalFormTests.ChildNodeTester<T, ExternalTableGenerator> buildTableGeneratorTester() {
        return new AbstractExternalFormTests.ChildNodeTester<T, ExternalTableGenerator>(){

            @Override
            public ExternalTableGenerator addChild(T form) {
                return form.addTableGenerator();
            }

            @Override
            public ExternalTableGenerator getChild(T form) {
                return form.getTableGenerator();
            }

            @Override
            public String getNodeName() {
                return "table-generator";
            }

            @Override
            public boolean hasChild(T form) {
                return form.hasTableGenerator();
            }

            @Override
            public void removeChild(T form) {
                form.removeTableGenerator();
            }
        };
    }

    final String buildUnionPartitioningTester() {
        return "union-partitioning";
    }

    final String buildUuidGeneratorTester() {
        return "uuid-generator";
    }

    final String buildValuePartitioningTester() {
        return "value-partitioning";
    }

    @Override
    String defaultClassName() {
        return "org.eclipse.persistence.tool.mappings.tests.MappedSuperclass";
    }

    @Override
    protected void populate(AbstractExternalFormTests.RootNodeTester tester) {
        tester.setBuilder(this.buildMappedSuperclassBuilder());
        tester.addAttribute(this.buildClassTester());
        tester.addAttribute(this.buildParentClassTester());
        tester.addAttribute(this.buildAccessTester());
        tester.addAttribute(this.buildCacheableTester());
        tester.addAttribute(this.buildMetadataCompleteTester());
        tester.addAttribute(this.buildReadOnlyTester());
        tester.addAttribute(this.buildExistenceCheckingTester());
        tester.addAttribute(this.buildExcludeDefaultMappingsTester());
        tester.addTextNode(this.buildDescriptionTester());
        tester.addNode(this.buildAccessMethodsTester());
        tester.addNode(this.buildMultitenantTester());
        tester.addUnsupportedNode(this.buildAdditionalCriteriaTester());
        tester.addChildAttribute(this.buildCustomizerTester());
        tester.addChildAttribute(this.buildChangeTrackingTester());
        tester.addChildAttribute(this.buildIdClassTester());
        tester.addNode(this.buildPrimaryKeyTester());
        tester.addNode(this.buildOptimisticLockingTester());
        tester.addNode(this.buildCacheTester());
        tester.addChildAttribute(this.buildCacheInterceptorTester());
        tester.addUnsupportedNode(this.buildCacheIndexTester());
        tester.addListNodes(this.buildFetchGroupTester());
        tester.addListNodes(this.buildConverterTester());
        tester.addListNodes(this.buildTypeConverterTester());
        tester.addListNodes(this.buildObjectTypeConverterTester());
        tester.addUnsupportedNode(this.buildSerializedConverterTester());
        tester.addListNodes(this.buildStructConverterTester());
        tester.addNode(this.buildCopyPolicyTester());
        tester.addNode(this.buildInstantiationCopyPolicyTester());
        tester.addNode(this.buildCloneCopyPolicyTester());
        tester.addUnsupportedNode(this.buildSerializedObjectTester());
        tester.addNode(this.buildSequenceGeneratorTester());
        tester.addNode(this.buildTableGeneratorTester());
        tester.addUnsupportedNode(this.buildUuidGeneratorTester());
        tester.addUnsupportedNode(this.buildPartitioningTester());
        tester.addUnsupportedNode(this.buildReplicationPartitioningTester());
        tester.addUnsupportedNode(this.buildRoundRobinPartitioningTester());
        tester.addUnsupportedNode(this.buildPinnedPartitioningTester());
        tester.addUnsupportedNode(this.buildRangePartitioningTester());
        tester.addUnsupportedNode(this.buildValuePartitioningTester());
        tester.addUnsupportedNode(this.buildHashPartitioningTester());
        tester.addUnsupportedNode(this.buildUnionPartitioningTester());
        tester.addUnsupportedNode(this.buildPartitionedTester());
        tester.addListNodes(this.buildNamedQueryTester());
        tester.addListNodes(this.buildNamedNativeQueryTester());
        tester.addListNodes(this.buildNamedStoredProcedureQueryTester());
        tester.addUnsupportedNode(this.buildNamedStoredFunctionQueryTester());
        tester.addUnsupportedNode(this.buildNamedPlsqlStoredProcedureQueryTester());
        tester.addUnsupportedNode(this.buildNamedPlsqlStoredFunctionQueryTester());
        tester.addUnsupportedNode(this.buildOracleObjectTester());
        tester.addUnsupportedNode(this.buildOracleArrayTester());
        tester.addUnsupportedNode(this.buildPlsqlRecordTester());
        tester.addUnsupportedNode(this.buildPlsqlTableTester());
        tester.addUnsupportedNode(this.buildSqlResultSetMappingTester());
        tester.addUnsupportedNode(this.buildQueryRedirectorsTester());
        tester.addBooleanNode(this.buildExcludeDefaultListenersTester());
        tester.addBooleanNode(this.buildExcludeSuperclassListenersTester());
        tester.addContainerListNodes(this.buildEntityListenersTester());
        tester.addChildAttribute(this.buildPrePersistClassTester());
        tester.addChildAttribute(this.buildPostPersistClassTester());
        tester.addChildAttribute(this.buildPreRemoveClassTester());
        tester.addChildAttribute(this.buildPostRemoveClassTester());
        tester.addChildAttribute(this.buildPreUpdateClassTester());
        tester.addChildAttribute(this.buildPostUpdateClassTester());
        tester.addChildAttribute(this.buildPostLoadClassTester());
        tester.addListNodes(this.buildPropertyTester());
        tester.addListNodes(this.buildAttributeOverrideTester());
        tester.addListNodes(this.buildAssociationOverrideTester());
        tester.addContainerListNodes(this.buildAttributesTester());
    }
}

