/*******************************************************************************
 * Copyright (c) 2007, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.gen.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * Collections of utility methods handling files.
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public class FileUtil {

	public static byte[] readFile(File src) throws IOException {
		FileInputStream fin = new FileInputStream(src);
		try {
			long fileLen = src.length();
			if (fileLen > Integer.MAX_VALUE) {
				throw new IOException("file length too big to be read by FileUtil.readFile: " + fileLen);
			}
			byte[] bytes = new byte[(int) fileLen];
			fin.read(bytes);
			return bytes;
		}
		finally {
			fin.close();
		}
	}

	public static void writeFile(File dest, byte[] bytes) throws IOException {
		if (dest.exists() && !dest.canWrite())
			throw new IOException(); // throw with a clear error because otherwise FileOutputStream
			// throws FileNotFoundException!
		FileOutputStream fout = new FileOutputStream(dest.getPath(), false/* append */);
		try {
			fout.write(bytes);
		}
		finally {
			fout.flush();
			fout.close();
		}
	}
}