/*******************************************************************************
 * Copyright (c) 1998, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
******************************************************************************/
package org.eclipse.persistence.tools.db.model.spi;

/**
 * Interface defining a lightweight wrapper around the database metadata.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see ExternalDatabase
 * @version 2.6
 */
public interface ExternalTableDescription extends TableDescription {

	/**
	 * Returns the ExternalTable object corresponding to this {@link ExternalTableDescription} object.
	 * This allows this <code>ExternalTableDescription</code> to postpone loading extra meta-data
	 * until it is actually needed. The name and description are required beforehand because they are
	 * used by the user to select an {@link ExternalTable} to load.
	 */
	ExternalTable getTable();
}