/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalClassConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalConverterProvider;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests.ChildListNodeTester;

/**
 * @version 2.6
 */
@SuppressWarnings("nls")
public final class ConverterTests {

	/**
	 * Creates a new <code>ConverterTests</code>.
	 */
	private ConverterTests() {
		super();
	}

	public static <T extends ExternalConverterProvider> ChildListNodeTester<T, ExternalClassConverter, String> buildConverterTester() {
		return new ChildListNodeTester<T, ExternalClassConverter, String>() {
			@Override
			public ExternalClassConverter addChild(T form, String value) {
				ExternalClassConverter converter = form.addConverter();
				converter.setName(value);
				return converter;
			}
			@Override
			public ExternalClassConverter getChild(T form, int index) {
				return form.getConverter(index);
			}
			@Override
			public ExternalClassConverter getChildForm(List<ExternalClassConverter> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalClassConverter> getChildren(T form) {
				return form.converters();
			}
			@Override
			public int getChildrenSize(T form) {
				return form.convertersSize();
			}
			@Override
			public String getChildValue(ExternalClassConverter childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "CLASS_CONVERTER_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalClassConverter.CONVERTER;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(T form, int index) {
				form.removeConverter(index);
			}
		};
	}

	public static <T extends ExternalConverterProvider> ChildListNodeTester<T, ExternalObjectTypeConverter, String> buildObjectTypeConverterTester() {
		return new ChildListNodeTester<T, ExternalObjectTypeConverter, String>() {
			@Override
			public ExternalObjectTypeConverter addChild(T form, String value) {
				ExternalObjectTypeConverter converter = form.addObjectTypeConverter();
				converter.setName(value);
				return converter;
			}
			@Override
			public ExternalObjectTypeConverter getChild(T form, int index) {
				return form.getObjectTypeConverter(index);
			}
			@Override
			public ExternalObjectTypeConverter getChildForm(List<ExternalObjectTypeConverter> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalObjectTypeConverter> getChildren(T form) {
				return form.objectTypeConverters();
			}
			@Override
			public int getChildrenSize(T form) {
				return form.objectTypeConvertersSize();
			}
			@Override
			public String getChildValue(ExternalObjectTypeConverter childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "OBJECT_TYPE_CONVERTER_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalObjectTypeConverter.OBJECT_TYPE_CONVERTER;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(T form, int index) {
				form.removeObjectTypeConverter(index);
			}
		};
	}

	public static String buildSerializedConverterTester() {
		return "serialized-converter";
	}

	public static <T extends ExternalConverterProvider> ChildListNodeTester<T, ExternalStructConverter, String> buildStructConverterTester() {
		return new ChildListNodeTester<T, ExternalStructConverter, String>() {
			@Override
			public ExternalStructConverter addChild(T form, String value) {
				ExternalStructConverter converter = form.addStructConverter();
				converter.setName(value);
				return converter;
			}
			@Override
			public ExternalStructConverter getChild(T form, int index) {
				return form.getStructConverter(index);
			}
			@Override
			public ExternalStructConverter getChildForm(List<ExternalStructConverter> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalStructConverter> getChildren(T form) {
				return form.structConverters();
			}
			@Override
			public int getChildrenSize(T form) {
				return form.structConvertersSize();
			}
			@Override
			public String getChildValue(ExternalStructConverter childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "STRUCT_CONVERTER_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalStructConverter.STRUCT_CONVERTER;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(T form, int index) {
				form.removeStructConverter(index);
			}
		};
	}

	public static <T extends ExternalConverterProvider> ChildListNodeTester<T, ExternalTypeConverter, String> buildTypeConverterTester() {
		return new ChildListNodeTester<T, ExternalTypeConverter, String>() {
			@Override
			public ExternalTypeConverter addChild(T form, String value) {
				ExternalTypeConverter converter = form.addTypeConverter();
				converter.setName(value);
				return converter;
			}
			@Override
			public ExternalTypeConverter getChild(T form, int index) {
				return form.getTypeConverter(index);
			}
			@Override
			public ExternalTypeConverter getChildForm(List<ExternalTypeConverter> childForms, int index) {
				return childForms.get(index);
			}
			@Override
			public List<ExternalTypeConverter> getChildren(T form) {
				return form.typeConverters();
			}
			@Override
			public int getChildrenSize(T form) {
				return form.typeConvertersSize();
			}
			@Override
			public String getChildValue(ExternalTypeConverter childForm) {
				return childForm.getName();
			}
			@Override
			public String getExpectedChildValue(int index) {
				return "TYPE_CONVERTER_" + index;
			}
			@Override
			public List<String> getExpectedChildValues() {
				List<String> values = new ArrayList<String>();
				for (int index = 0; index < 10; index++) {
					values.add(getExpectedChildValue(index));
				}
				return values;
			}
			@Override
			public String getNodeName() {
				return ExternalTypeConverter.TYPE_CONVERTER;
			}
			@Override
			public List<String> getNodeNames() {
				return Collections.singletonList(getNodeName());
			}
			@Override
			public void removeChild(T form, int index) {
				form.removeTypeConverter(index);
			}
		};
	}
}