/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.model.value;

import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterator.EmptyIterator;
import org.eclipse.persistence.tools.utility.iterator.EmptyListIterator;
import org.eclipse.persistence.tools.utility.model.AbstractModel;

/**
 * An empty list value model for when you don't
 * need to support a list.
 * <p>
 * We don't use a singleton because we hold on to listeners.
 */
@SuppressWarnings("nls")
public final class NullListValueModel<E>
	extends AbstractModel
	implements ListValueModel<E>, Serializable
{
	private static final long serialVersionUID = 1L;

	/**
	 * Default constructor.
	 */
	public NullListValueModel() {
		super();
	}


	// ********** ListValueModel implementation **********

	@Override
	public Iterator<E> iterator() {
		return EmptyIterator.instance();
	}

	@Override
	public ListIterator<E> listIterator() {
		return EmptyListIterator.instance();
	}

	@Override
	public int size() {
		return 0;
	}

	@Override
	public E get(int index) {
		throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
	}

	@Override
	public Object[] toArray() {
		return ObjectTools.EMPTY_OBJECT_ARRAY;
	}


	// ********** Object overrides **********

	@Override
	public String toString() {
		return this.getClass().getSimpleName();
	}
}