/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.EnumType;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describes the configurable properties for a basic mapping
 * in the ORM xml. A basic mapping may be defined on either a mapped superclass or regular entity.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.Basic
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html,
 * persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalBasicMapping extends ExternalVersionMapping,
                                              ExternalGeneratedMapping,
                                              ExternalMappedMapping {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String BASIC = "basic";

	/**
	 * The element name used to store and retrieve the expiry child text node.
	 */
	String ENUMERATED = "enumerated";

	/**
	 * The attribute name used to store and retrieve the fetch property.
	 */
	String FETCH = "fetch";

	/**
	 * The element name used to store and retrieve the lob child text node.
	 */
	String LOB = "lob";

	/**
	 * The attribute name used to store and retrieve the mutable property.
	 */
	String MUTABLE = "mutable";

	/**
	 * The attribute name used to store and retrieve the optional property.
	 */
	String OPTIONAL = "optional";

	/**
	 * Returns insert property.
	 */
	String RETURN_INSERT = "return-insert";

	/**
	 * Returns only on insert property.
	 */
	String RETURN_ONLY = "return-only";

	/**
	 * Returns update property.
	 */
	String RETURN_UPDATE = "return-update";

	/**
	 * The element name used to store and retrieve the temporal child text node.
	 */
	String TEMPORAL = "temporal";

	/**
	 * Returns the enumerated type of this mapping if one exists.
	 */
	EnumType getEnumeratedType();

	/**
	 * Returns the {@link TextRange} for the enumerated type value.
	 */
	TextRange getEnumeratedTypeTextRange();

	/**
	 * Returns the {@link TextRange} for the LOB value.
	 */
	TextRange getLobTextRange();

	/**
	 * Returns the {@link TextRange} for the return on insert value.
	 */
	TextRange getReturnOnInsertTextRange();

	/**
	 * Returns the {@link TextRange} for the return only on insert value.
	 */
	TextRange getReturnOnlyOnInsertTextRange();

	/**
	 * Returns the {@link TextRange} for the return on update value.
	 */
	TextRange getReturnOnUpdateTextRange();

	/**
	 * Indicates whether this basic mapping's column is a LOB.
	 */
	Boolean isLob();

	/**
	 * Returns whether this mapping returns on insert.
	 */
	Boolean returnOnInsert();

	/**
	 * Returns whether this mapping returns only on insert.
	 */
	Boolean returnOnlyOnInsert();

	/**
	 * Returns whether this mapping returns on update.
	 */
	Boolean returnOnUpdate();

	/**
	 * Sets enumerated type.
	 */
	void setEnumeratedType(EnumType type);

	/**
	 * Sets mapping as lob.
	 */
	void setLob(Boolean lob);

	/**
	 * Sets whether this mapping returns on insert.
	 */
	void setReturnOnInsert(Boolean returnOnInsert);

	/**
	 * Sets whether this mapping only returns on insert.
	 */
	void setReturnOnlyOnInsert(Boolean returnOnlyOnInsert);

	/**
	 * Sets whether this mapping returns on update.
	 */
	void setReturnOnUpdate(Boolean returnOnUpdate);
}