/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.LockModeType;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface extends that defined by {@link ExternalNamedQuery} to include the LockModeType
 * property that is carried by JPA NamedQuery objects but not other query types.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalBasicNamedQuery extends ExternalNamedQuery {

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	static final String LOCK_MODE = "lock-mode";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	static final String NAMED_QUERY = "named-query";

	/**
	 * Returns the locking mode to be used for this query.
	 */
	LockModeType getLockModeType();

	/**
	 * Returns the {@link TextRange} for the locking mode value.
	 */
	TextRange getLockModeTypeTextRange();

	/**
	 * Sets the locking mode to be used for this query.
	 */
	void setLockModeType(LockModeType lockModeType);
}