/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;

/**
 * Defines an external ORM object that holds on to different flavor of converters.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
public interface ExternalConverterProvider extends ExternalForm {

	/**
	 * Adds a converter to this entity.
	 */
	ExternalClassConverter addConverter();

	/**
	 * Adds a object type converter to this entity.
	 */
	ExternalObjectTypeConverter addObjectTypeConverter();

	/**
	 * Adds a struct converter to this entity.
	 */
	ExternalStructConverter addStructConverter();

	/**
	 * Adds a type converter to this entity.
	 */
	ExternalTypeConverter addTypeConverter();

	/**
	 * Returns a list of the converters defined for this entity.
	 */
	List<ExternalClassConverter> converters();

	/**
	 * Returns the count of converters defined for this entity.
	 */
	int convertersSize();

	/**
	 * Returns the converter at the given position.
	 */
	ExternalClassConverter getConverter(int index);

	/**
	 * Returns the object type converter at the given position.
	 */
	ExternalObjectTypeConverter getObjectTypeConverter(int index);

	/**
	 * Returns the struct type converter at the given position.
	 */
	ExternalStructConverter getStructConverter(int index);

	/**
	 * Returns the converter at the given position.
	 */
	ExternalTypeConverter getTypeConverter(int index);

	/**
	 * Returns a list of the object type converters defined for this entity.
	 */
	List<ExternalObjectTypeConverter> objectTypeConverters();

	/**
	 * Returns the count of the object type converters defined for this entity.
	 */
	int objectTypeConvertersSize();

	/**
	 * Removes the converter specified at the given position.
	 */
	void removeConverter(int index);

	/**
	 * Removes the object type converter specified at the given position.
	 */
	void removeObjectTypeConverter(int index);

	/**
	 * Removes the struct converter specified at the given position.
	 */
	void removeStructConverter(int index);

	/**
	 * Removes the type converter specified at the given position.
	 */
	void removeTypeConverter(int index);

	/**
	 * Returns a list of the struct converters defined for this entity.
	 */
	List<ExternalStructConverter> structConverters();

	/**
	 * Returns the count of converters defined for this entity.
	 */
	int structConvertersSize();

	/**
	 * Returns a list of the converters defined for this entity.
	 */
	List<ExternalTypeConverter> typeConverters();

	/**
	 * Returns the count of type converters defined for this entity.
	 */
	int typeConvertersSize();
}