/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.DiscriminatorType;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface describes the configurable properties for a discriminator column in the ORM xml.
 * A discriminator column is owned by an entity and is used in inheritence to dicate the type of
 * entity to instantiate at runtime.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.DiscriminatorColumn
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalDiscriminatorColumn extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the column-definition property.
	 */
	String COLUMN_DEFINITION = "column-definition";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String DISCRIMINATOR_COLUMN = "discriminator-column";

	/**
	 * The attribute name used to store and retrieve the discriminator-type property.
	 */
	String DISCRIMINATOR_TYPE = "discriminator-type";

	/**
	 * The attribute name used to store and retrieve the length property.
	 */
	String LENGTH = "length";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * Returns the SQL definition of the column.
	 */
	String getColumnDefinition();

	/**
	 * Returns the {@link TextRange} for the SQL definition of the column.
	 */
	TextRange getColumnDefinitionTextRange();

	/**
	 * Type of the discriminator column.
	 */
	DiscriminatorType getDiscriminatorType();

	/**
	 * Returns the {@link TextRange} for the type of the discriminator column.
	 */
	TextRange getDiscriminatorTypeTextRange();

	/**
	 * Returns the length of the column.
	 */
	Integer getLength();

	/**
	 * Returns the {@link TextRange} for the length of the column.
	 */
	TextRange getLengthTextRange();

	/**
	 * Name of the discriminator column.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} for the name of the discriminator column.
	 */
	TextRange getNameTextRange();

	/**
	 * Set the column definition
	 */
	void setColumnDefinition(String definition);

	/**
	 * Set the discriminator type
	 */
	void setDiscriminatorType(DiscriminatorType type);

	/**
	 * Set the length
	 */
	void setLength(Integer length);

	/**
	 * Sets the name of the column
	 */
	void setName(String name);
}