/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * The interface is used to traverse the mapping SPI. It follows the Visitor pattern. It visits
 * the leaf interfaces of {@link ExternalMapping}.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.
 *
 * @version 2.6
 */
public interface ExternalMappingVisitor {

	/**
	 * Visits the {@link ExternalBasicCollectionMapping} expression.
	 *
	 * @param expression The {@link ExternalBasicCollectionMapping} to visit
	 */
	void visit(ExternalBasicCollectionMapping mapping);

	/**
	 * Visits the {@link ExternalBasicMapMapping} expression.
	 *
	 * @param expression The {@link ExternalBasicMapMapping} to visit
	 */
	void visit(ExternalBasicMapMapping mapping);

	/**
	 * Visits the {@link ExternalBasicMapping} expression.
	 *
	 * @param expression The {@link ExternalBasicMapping} to visit
	 */
	void visit(ExternalBasicMapping mapping);

	/**
	 * Visits the {@link ExternalElementCollectionMapping} expression.
	 *
	 * @param expression The {@link ExternalElementCollectionMapping} to visit
	 */
	void visit(ExternalElementCollectionMapping mapping);

	/**
	 * Visits the {@link ExternalEmbeddedIDMapping} expression.
	 *
	 * @param expression The {@link ExternalEmbeddedIDMapping} to visit
	 */
	void visit(ExternalEmbeddedIDMapping mapping);

	/**
	 * Visits the {@link ExternalEmbeddedMapping} expression.
	 *
	 * @param expression The {@link ExternalEmbeddedMapping} to visit
	 */
	void visit(ExternalEmbeddedMapping mapping);

	/**
	 * Visits the {@link ExternalIDMapping} expression.
	 *
	 * @param expression The {@link ExternalIDMapping} to visit
	 */
	void visit(ExternalIDMapping mapping);

	/**
	 * Visits the {@link ExternalManyToManyMapping} expression.
	 *
	 * @param expression The {@link ExternalManyToManyMapping} to visit
	 */
	void visit(ExternalManyToManyMapping mapping);

	/**
	 * Visits the {@link ExternalManyToOneMapping} expression.
	 *
	 * @param expression The {@link ExternalManyToOneMapping} to visit
	 */
	void visit(ExternalManyToOneMapping mapping);

	/**
	 * Visits the {@link ExternalOneToManyMapping} expression.
	 *
	 * @param expression The {@link ExternalOneToManyMapping} to visit
	 */
	void visit(ExternalOneToManyMapping mapping);

	/**
	 * Visits the {@link ExternalOneToOneMapping} expression.
	 *
	 * @param expression The {@link ExternalOneToOneMapping} to visit
	 */
	void visit(ExternalOneToOneMapping mapping);

	/**
	 * Visits the {@link ExternalTransformationMapping} expression.
	 *
	 * @param expression The {@link ExternalTransformationMapping} to visit
	 */
	void visit(ExternalTransformationMapping mapping);

	/**
	 * Visits the {@link ExternalTransientMapping} expression.
	 *
	 * @param expression The {@link ExternalTransientMapping} to visit
	 */
	void visit(ExternalTransientMapping mapping);

	/**
	 * Visits the {@link ExternalVariableOneToOneMapping} expression.
	 *
	 * @param expression The {@link ExternalVariableOneToOneMapping} to visit
	 */
	void visit(ExternalVariableOneToOneMapping mapping);

	/**
	 * Visits the {@link ExternalVersionMapping} expression.
	 *
	 * @param expression The {@link ExternalVersionMapping} to visit
	 */
	void visit(ExternalVersionMapping mapping);
}