/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * Defines in the ORM.xml the abstract behavior inherent to all primary key generators.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalPrimaryKeyGenerator extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the allocation-size of the property.
	 */
	String ALLOCATION_SIZE = "allocation-size";

	/**
	 * The attribute name used to store and retrieve the temporal property.
	 */
	String CATALOG = "catalog";

	/**
	 * The element name of the child text node for the description.
	 */
	String DESCRIPTION = "description";

	/**
	 * The attribute name used to store and retrieve the initial-value of the property.
	 */
	String INITIAL_VALUE = "initial-value";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * The attribute name used to store and retrieve the temporal property.
	 */
	String SCHEMA = "schema";

	/**
	 * Returns the allocation size for this generator.
	 */
	Integer getAllocationSize();

	/**
	 * Returns the {@link TextRange} of the allocation size value.
	 */
	TextRange getAllocationSizeTextRange();

	/**
	 * Returns the name of the catalog for the table that will be generated.
	 */
	String getCatalogName();

	/**
	 * Returns the {@link TextRange} for the catalog name.
	 */
	TextRange getCatalogNameTextRange();

	/**
	 * Returns the description noted in the ORM.xml.
	 */
	String getDescription();

	@Deprecated
	int getIndex();

	/**
	 * Returns the initial value of the generator.
	 */
	Integer getInitialValue();

	/**
	 * Returns the {@link TextRange} of the initial value value.
	 */
	TextRange getInitialValueTextRange();

	/**
	 * Returns the name for this generator.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} of the name value.
	 */
	TextRange getNameTextRange();

	/**
	 * Returns the schema name for the table that will be generated.
	 */
	String getSchemaName();

	/**
	 * Returns the {@link TextRange} for the schema name.
	 */
	TextRange getSchemaNameTextRange();

	/**
	 * Set the allocation size for this generator.
	 */
	void setAllocationSize(Integer size);

	/**
	 * Set the catalog name.
	 */
	void setCatalogName(String name);

	/**
	 * Set the description
	 */
	void setDescription(String description);

	/**
	 * Set the initial value for the generator.
	 */
	void setInitialValue(Integer value);

	/**
	 * Set the name of this generator.
	 */
	void setName(String name);

	/**
	 * Set the schema name.
	 */
	void setSchemaName(String name);
}