/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface represents the transformation mapping defined by the EclipseLink JPA spec that are
 * available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalTransformationMapping extends ExternalMappedMapping {

	/**
	 * The attribute name used to store and retrieve the fetch property.
	 */
	String FETCH = "fetch";

	/**
	 * The attribute name used to store and retrieve the mutable property.
	 */
	String MUTABLE = "mutable";

	/**
	 * The attribute name used to store and retrieve the optional property.
	 */
	String OPTIONAL = "optional";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String TRANSFORMATION = "transformation";

	/**
	 * Visits this {@link ExternalTransformationMapping} by the given {@link ExternalMappingVisitor visitor}.
	 *
	 * @param visitor The {@link ExternalMappingVisitor} to visit this object
	 */
	void accept(ExternalMappingVisitor visitor);

	/**
	 * Adds the read transformer.
	 */
	ExternalTransformer addReadTransformer();

	/**
	 * Adds a write transformer.
	 */
	ExternalWriteTransformer addWriteTransformer();

	/**
	 * Returns the {@link TextRange} for the mutable value.
	 */
	TextRange getMutableTextRange();

	/**
	 * Returns the read transformer.
	 */
	ExternalReadTransformer getReadTransformer();

	/**
	 * Returns the write transformer at the index.
	 */
	ExternalWriteTransformer getWriteTransformer(int index);

	/**
	 * Returns whether the mapping is mutable.
	 */
	Boolean isMutable();

	/**
	 * Removes the read transformer.
	 */
	void removeReadTransformer();

	/**
	 * Removes the write transformer at the index.
	 */
	void removeWriteTransformer(int index);

	/**
	 * Sets whether the mapping is mutable or not.
	 */
	void setIsMutable(Boolean mutable);

	/**
	 * Returns all the write transformers.
	 */
	List<ExternalWriteTransformer> writeTransformers();

	/**
	 * Returns the number of write transformers.
	 */
	int writeTransformersSize();
}