/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ServerError;
import java.io.IOException;
import org.bson.BSONObject;

public class MongoException
extends RuntimeException {
    private static final long serialVersionUID = -4415279469780082174L;
    final int _code;

    public MongoException(String msg) {
        super(msg);
        this._code = -3;
    }

    public MongoException(int code, String msg) {
        super(msg);
        this._code = code;
    }

    public MongoException(String msg, Throwable t) {
        super(msg, MongoException._massage(t));
        this._code = -4;
    }

    public MongoException(int code, String msg, Throwable t) {
        super(msg, MongoException._massage(t));
        this._code = code;
    }

    public MongoException(BSONObject o) {
        this(ServerError.getCode(o), ServerError.getMsg(o, "UNKNOWN"));
    }

    static MongoException parse(BSONObject o) {
        String s = ServerError.getMsg(o, null);
        if (s == null) {
            return null;
        }
        return new MongoException(ServerError.getCode(o), s);
    }

    static Throwable _massage(Throwable t) {
        if (t instanceof Network) {
            return ((Network)t)._ioe;
        }
        return t;
    }

    public int getCode() {
        return this._code;
    }

    public static class CursorNotFound
    extends MongoException {
        private static final long serialVersionUID = -4415279469780082174L;

        CursorNotFound() {
            super(-5, "cursor not found on server");
        }
    }

    public static class DuplicateKey
    extends MongoException {
        private static final long serialVersionUID = -4415279469780082174L;

        DuplicateKey(int code, String msg) {
            super(code, msg);
        }
    }

    public static class Network
    extends MongoException {
        private static final long serialVersionUID = -4415279469780082174L;
        final IOException _ioe;

        Network(String msg, IOException ioe) {
            super(-2, msg, ioe);
            this._ioe = ioe;
        }

        Network(IOException ioe) {
            super(ioe.toString(), ioe);
            this._ioe = ioe;
        }
    }
}

