/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableColumn;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveTablePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionOrdering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.QueryKeyCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.BidiTransformer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullListIterator;

final class CollectionOrderingPanel
extends AbstractSubjectPanel {
    public CollectionOrderingPanel(ValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    MWCollectionMapping getCollectionMapping() {
        return (MWCollectionMapping)this.getSubjectHolder().getValue();
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        AddRemoveTablePanel orderingsPanel = this.buildOrderingsTablePanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)orderingsPanel, constraints);
    }

    private AddRemoveTablePanel buildOrderingsTablePanel() {
        AddRemoveTablePanel tablePanel = new AddRemoveTablePanel(this.getApplicationContext(), this.buildTablePanelAdapter(), this.buildOrderingsListModel(), this.buildOrderingColumnAdapter(), 3, this.buildOrderingSelector());
        this.updateTableColumns((JTable)tablePanel.getComponent());
        return tablePanel;
    }

    private void updateTableColumns(JTable table) {
        int rowHeight = 0;
        TableColumn column = table.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer orderingRenderer = this.buildOrderingComboBoxRenderer();
        column.setCellRenderer(orderingRenderer);
        column.setCellEditor(new TableCellEditorAdapter(this.buildOrderingComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, orderingRenderer.getPreferredHeight());
        column = table.getColumnModel().getColumn(0);
        ComboBoxTableCellRenderer queryKeyRenderer = this.buildQueryKeyComboBoxRenderer();
        column.setCellRenderer(queryKeyRenderer);
        column.setCellEditor(new TableCellEditorAdapter(this.buildQueryKeyComboBoxRenderer()));
        table.setRowHeight(rowHeight);
    }

    private AddRemovePanel.UpDownAdapter buildTablePanelAdapter() {
        return new AddRemovePanel.UpDownAdapter(){

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] selectedValues = listSelectionModel.getSelectedValues();
                for (int i = 0; i < selectedValues.length; ++i) {
                    CollectionOrderingPanel.this.getCollectionMapping().removeOrdering((MWCollectionOrdering)selectedValues[i]);
                }
            }

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                if (CollectionOrderingPanel.this.getCollectionMapping().getReferenceDescriptor() != null) {
                    Collection queryKeys = CollectionOrderingPanel.this.getCollectionMapping().getReferenceDescriptor().getAllQueryKeysIncludingInherited();
                    if (queryKeys.size() == 0) {
                        CollectionOrderingPanel.this.getCollectionMapping().addOrdering(null);
                    } else {
                        CollectionOrderingPanel.this.getCollectionMapping().addOrdering((MWQueryKey)queryKeys.iterator().next());
                    }
                } else {
                    CollectionOrderingPanel.this.getCollectionMapping().addOrdering(null);
                }
            }

            @Override
            public void moveItemsDown(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    CollectionOrderingPanel.this.getCollectionMapping().moveOrderingDown((MWCollectionOrdering)items[i]);
                }
            }

            @Override
            public void moveItemsUp(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    CollectionOrderingPanel.this.getCollectionMapping().moveOrderingUp((MWCollectionOrdering)items[i]);
                }
            }
        };
    }

    private ListValueModel buildOrderingsListModel() {
        return new ListAspectAdapter(this.getSubjectHolder(), "orderings"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWCollectionMapping)this.subject).orderings();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWCollectionMapping)this.subject).orderingsSize();
            }
        };
    }

    private ColumnAdapter buildOrderingColumnAdapter() {
        return new OrderingsColumnAdapter(this.resourceRepository());
    }

    private ComboBoxModel buildOrderingComboBoxModel() {
        return new DefaultComboBoxModel<Object>(new Object[]{this.resourceRepository().getString("ASCENDING_OPTION"), this.resourceRepository().getString("DESCENDING_OPTION")});
    }

    private ComboBoxTableCellRenderer buildOrderingComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildOrderingComboBoxModel());
    }

    private ComboBoxTableCellRenderer buildQueryKeyComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildQueryKeyComboBoxModel(), this.buildQueryListCellRenderer());
    }

    private ListCellRenderer buildQueryListCellRenderer() {
        return new AdaptableListCellRenderer(new QueryKeyCellRendererAdapter(this.resourceRepository()));
    }

    private NodeSelector buildOrderingSelector() {
        return new NodeSelector(){

            @Override
            public void selectNodeFor(Object item) {
                RelationalProjectNode projectNode = (RelationalProjectNode)CollectionOrderingPanel.this.navigatorSelectionModel().getSelectedProjectNodes()[0];
                projectNode.selectQueryKey(((MWCollectionOrdering)item).getQueryKey(), CollectionOrderingPanel.this.getWorkbenchContext());
            }
        };
    }

    private CachingComboBoxModel buildQueryKeyComboBoxModel() {
        return new IndirectComboBoxModel(new SimplePropertyValueModel(), this.getSubjectHolder()){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return CollectionOrderingPanel.this.orderedQueryKeyChoices((MWCollectionMapping)subject);
            }
        };
    }

    ListIterator orderedQueryKeyChoices(MWCollectionMapping collectionMapping) {
        MWRelationalDescriptor referenceDescriptor = (MWRelationalDescriptor)collectionMapping.getReferenceDescriptor();
        if (referenceDescriptor != null) {
            return CollectionTools.sort((Iterator)referenceDescriptor.allQueryKeysIncludingInherited()).listIterator();
        }
        return NullListIterator.instance();
    }

    private static class OrderingsColumnAdapter
    implements ColumnAdapter {
        ResourceRepository resourceRepository;
        public static final int QUERY_KEY_COLUMN = 0;
        public static final int ORDER_COLUMN = 1;
        public static final int COLUMN_COUNT = 2;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"QUERY_KEY_COLUMN_HEADER", "ORDER_COLUMN_HEADER"};

        private OrderingsColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        private PropertyValueModel buildQueryKeyAdapter(MWCollectionOrdering ordering) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("queryKey", (Model)ordering){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWCollectionOrdering)this.subject).getQueryKey();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWCollectionOrdering)this.subject).setQueryKey((MWQueryKey)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }

        private PropertyValueModel buildOrderAdapter(MWCollectionOrdering ordering) {
            return new TransformationPropertyValueModel(new PropertyAspectAdapter("ascending", (Model)ordering){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWCollectionOrdering)this.subject).isAscending();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWCollectionOrdering)this.subject).setAscending(((Boolean)value).booleanValue());
                }
            }, new BidiTransformer(){

                public Object reverseTransform(Object o) {
                    if (o == null) {
                        return Boolean.FALSE;
                    }
                    if (((String)o).equals(OrderingsColumnAdapter.this.resourceRepository.getString("ASCENDING_OPTION"))) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }

                public Object transform(Object o) {
                    if (((Boolean)o).equals(Boolean.TRUE)) {
                        return OrderingsColumnAdapter.this.resourceRepository.getString("ASCENDING_OPTION");
                    }
                    return OrderingsColumnAdapter.this.resourceRepository.getString("DESCENDING_OPTION");
                }
            });
        }

        @Override
        public PropertyValueModel[] cellModels(Object subject) {
            MWCollectionOrdering ordering = (MWCollectionOrdering)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildQueryKeyAdapter(ordering), this.buildOrderAdapter(ordering)};
            return result;
        }

        @Override
        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[index]);
        }

        @Override
        public boolean isColumnEditable(int index) {
            return true;
        }
    }
}

