/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCompoundExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Undoable;

public abstract class MWExpression
extends MWModel
implements Undoable {
    private volatile String operatorType;
    public static final String OPERATOR_TYPE_PROPERTY = "operatorType";

    protected MWExpression() {
    }

    MWExpression(MWModel parent, String operatorType) {
        super(parent);
        this.operatorType = operatorType;
    }

    public abstract String getIndex();

    public String getOperatorType() {
        return this.operatorType;
    }

    public abstract MWCompoundExpression getParentCompoundExpression();

    public abstract MWCompoundExpression getRootCompoundExpression();

    public abstract void clearExpressions();

    @Override
    public void undoChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == OPERATOR_TYPE_PROPERTY) {
            this.setOperatorType((String)oldValue);
        }
    }

    abstract void recalculateQueryables();

    public void setOperatorType(String operatorType) {
        String oldOperatorType = this.getOperatorType();
        this.operatorType = operatorType;
        this.firePropertyChanged(OPERATOR_TYPE_PROPERTY, oldOperatorType, operatorType);
        this.getRootCompoundExpression().propertyChanged(this, OPERATOR_TYPE_PROPERTY, oldOperatorType, operatorType);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWExpression.class);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("expression-class/text()");
        ip.readSubclassesOnQueries();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWBasicExpression.class, (Object)"basic");
        ip.addClassIndicator(MWCompoundExpression.class, (Object)"compound");
        ObjectTypeConverter operatorTypeConverter = new ObjectTypeConverter();
        operatorTypeConverter.addConversionValue((Object)"AND", (Object)"AND");
        operatorTypeConverter.addConversionValue((Object)"OR", (Object)"OR");
        operatorTypeConverter.addConversionValue((Object)"NAND", (Object)"NAND");
        operatorTypeConverter.addConversionValue((Object)"NOR", (Object)"NOR");
        operatorTypeConverter.addConversionValue((Object)"EQUAL", (Object)"EQUAL");
        operatorTypeConverter.addConversionValue((Object)"EQUALS IGNORE CASE", (Object)"EQUALS IGNORE CASE");
        operatorTypeConverter.addConversionValue((Object)"GREATER THAN", (Object)"GREATER THAN");
        operatorTypeConverter.addConversionValue((Object)"GREATER THAN EQUAL", (Object)"GREATER THAN EQUAL");
        operatorTypeConverter.addConversionValue((Object)"IS NULL", (Object)"IS NULL");
        operatorTypeConverter.addConversionValue((Object)"LESS THAN", (Object)"LESS THAN");
        operatorTypeConverter.addConversionValue((Object)"LESS THAN EQUAL", (Object)"LESS THAN EQUAL");
        operatorTypeConverter.addConversionValue((Object)"LIKE", (Object)"LIKE");
        operatorTypeConverter.addConversionValue((Object)"LIKE IGNORE CASE", (Object)"LIKE IGNORE CASE");
        operatorTypeConverter.addConversionValue((Object)"NOT EQUAL", (Object)"NOT EQUAL");
        operatorTypeConverter.addConversionValue((Object)"NOT LIKE", (Object)"NOT LIKE");
        operatorTypeConverter.addConversionValue((Object)"NOT NULL", (Object)"NOT NULL");
        XMLDirectMapping operatorTypeMapping = new XMLDirectMapping();
        operatorTypeMapping.setAttributeName(OPERATOR_TYPE_PROPERTY);
        operatorTypeMapping.setXPath("operator-type/text()");
        operatorTypeMapping.setConverter((Converter)operatorTypeConverter);
        descriptor.addMapping((DatabaseMapping)operatorTypeMapping);
        return descriptor;
    }

    abstract Expression buildRuntimeExpression(ExpressionBuilder var1);
}

