/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.tests.validation.EmployeeWithProblems;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class NormalDescriptorsDoNotSupportNonRelationalExtensionsTest
extends ExceptionTest {
    String methodName;
    IntegrityChecker orgIntegrityChecker;

    public NormalDescriptorsDoNotSupportNonRelationalExtensionsTest(String methodName) {
        this.methodName = methodName;
        this.setDescription("This tests Normal Descriptors Do Not Support Non Relational Extensions (" + methodName + ") ( TL-ERROR 157) " + "");
    }

    protected void setup() {
        this.expectedException = DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(null);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        block9: {
            RelationalDescriptor descriptor = this.descriptor();
            try {
                if (this.methodName.equals("buildDirectValuesFromFieldValue")) {
                    descriptor.buildDirectValuesFromFieldValue(null);
                    break block9;
                }
                if (this.methodName.equals("buildFieldValueFromDirectValues")) {
                    descriptor.buildFieldValueFromDirectValues(null, null, (AbstractSession)this.getSession());
                    break block9;
                }
                if (this.methodName.equals("buildFieldValueFromForeignKeys")) {
                    descriptor.buildFieldValueFromForeignKeys(null, null, (AbstractSession)this.getSession());
                    break block9;
                }
                if (this.methodName.equals("buildFieldValueFromNestedRow")) {
                    descriptor.buildFieldValueFromNestedRow(null, (AbstractSession)this.getSession());
                    break block9;
                }
                if (this.methodName.equals("buildFieldValueFromNestedRows")) {
                    descriptor.buildFieldValueFromNestedRows(null, null, (AbstractSession)this.getSession());
                    break block9;
                }
                if (this.methodName.equals("buildNestedRowFromFieldValue")) {
                    descriptor.buildNestedRowFromFieldValue(null);
                    break block9;
                }
                if (this.methodName.equals("buildNestedRowsFromFieldValue")) {
                    descriptor.buildNestedRowsFromFieldValue(null, (AbstractSession)this.getSession());
                    break block9;
                }
                throw new TestProblemException("Wrong method name");
            }
            catch (EclipseLinkException exception) {
                this.caughtException = exception;
            }
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmployeeWithProblems.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addTableName("ADDRESS");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        return descriptor;
    }
}

