/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.LoginExternalOptionsPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.RdbmsLoginPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.AbstractLoginPropertiesPage;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class RdbmsConnectionPropertiesPage
extends AbstractLoginPropertiesPage {
    private PseudoExternalConnectionPoolingModel pseudoModel;

    public RdbmsConnectionPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
        this.addHelpTopicId(this, "session.login.database.connection");
    }

    private PropertyValueModel buildDatabasePlatformHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "platformClass"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                String platformClass = login.getPlatformClass();
                if (platformClass == null) {
                    return null;
                }
                try {
                    return DatabasePlatformRepository.getDefault().platformForRuntimePlatformClassNamed(platformClass);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.subject;
                DatabasePlatform platform = (DatabasePlatform)value;
                if (platform != null) {
                    login.setPlatformClass(platform.getRuntimePlatformClassName());
                }
            }
        };
    }

    @Override
    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JComponent platformWidgets = this.buildLabeledComponent("CONNECTION_RDBMS_DATABASE_PLATFORM_FIELD", PlatformComponentFactory.buildPlatformChooser(this.buildDatabasePlatformHolder()));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)platformWidgets, constraints);
        this.addHelpTopicId(platformWidgets, "session.login.database.connection.platform");
        RdbmsLoginPane loginPane = new RdbmsLoginPane(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)loginPane, constraints);
        this.addPaneForAlignment(loginPane);
        CustomizedExternalOptionsPane optionsPane = new CustomizedExternalOptionsPane();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)optionsPane, constraints);
        return panel;
    }

    private PropertyChangeListener buildSelectionHolderListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                RdbmsConnectionPropertiesPage.this.pseudoModel.setParentNode((Node)((AbstractNodeModel)e.getNewValue()));
            }
        };
    }

    @Override
    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.getSelectionHolder().addPropertyChangeListener("value", this.buildSelectionHolderListener());
        this.pseudoModel = new PseudoExternalConnectionPoolingModel();
        this.pseudoModel.setParentNode((Node)((AbstractNodeModel)this.selection()));
    }

    private class PseudoExternalConnectionPoolingModel
    extends AbstractNodeModel {
        private boolean enabled;
        private PropertyChangeListener listener;
        private PropertyChangeListener managedListener;
        private PropertyChangeListener serverPlatformListener;
        private SessionBrokerAdapter sessionBroker;
        public static final String ENABLED_PROPERTY = "enabled";

        private PseudoExternalConnectionPoolingModel() {
        }

        private PropertyChangeListener buildManagedPropertyChangeListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    DatabaseLoginAdapter login = (DatabaseLoginAdapter)PseudoExternalConnectionPoolingModel.this.getParent();
                    SessionAdapter session = (SessionAdapter)login.getParent();
                    if (PseudoExternalConnectionPoolingModel.this.sessionBroker != null) {
                        ServerPlatformAdapter serverPlatform = PseudoExternalConnectionPoolingModel.this.sessionBroker.getServerPlatform();
                        serverPlatform.removePropertyChangeListener("enableJTA", PseudoExternalConnectionPoolingModel.this.listener);
                    }
                    DatabaseSessionAdapter databaseSession = (DatabaseSessionAdapter)session;
                    PseudoExternalConnectionPoolingModel.this.sessionBroker = databaseSession.getBroker();
                    ServerPlatformAdapter serverPlatform = session.getServerPlatform();
                    serverPlatform.addPropertyChangeListener("enableJTA", PseudoExternalConnectionPoolingModel.this.listener);
                    PseudoExternalConnectionPoolingModel.this.updateEnableState();
                }
            };
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    PseudoExternalConnectionPoolingModel.this.updateEnableState();
                }
            };
        }

        private PropertyChangeListener buildServerPlatformPropertyChangeListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    ServerPlatformAdapter oldServerPlatform = (ServerPlatformAdapter)((Object)e.getOldValue());
                    oldServerPlatform.removePropertyChangeListener("enableJTA", PseudoExternalConnectionPoolingModel.this.listener);
                    ServerPlatformAdapter newServerPlatform = (ServerPlatformAdapter)((Object)e.getNewValue());
                    newServerPlatform.addPropertyChangeListener("enableJTA", PseudoExternalConnectionPoolingModel.this.listener);
                    PseudoExternalConnectionPoolingModel.this.updateEnableState();
                }
            };
        }

        protected void checkParent(Node parent) {
        }

        private void disengageListeners() {
            DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.getParent();
            login.removePropertyChangeListener("useDriverManager", this.listener);
            SessionAdapter session = (SessionAdapter)login.getParent();
            session.removePropertyChangeListener("serverPlatform", this.serverPlatformListener);
            ServerPlatformAdapter serverPlatform = this.sessionBroker != null ? this.sessionBroker.getServerPlatform() : session.getServerPlatform();
            serverPlatform.removePropertyChangeListener("enableJTA", this.listener);
            if (!session.isBroker()) {
                DatabaseSessionAdapter databaseSession = (DatabaseSessionAdapter)session;
                databaseSession.removePropertyChangeListener("managedByBroker", this.managedListener);
                this.sessionBroker = null;
            }
        }

        public String displayString() {
            return null;
        }

        private void engageListeners() {
            DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.getParent();
            login.addPropertyChangeListener("useDriverManager", this.listener);
            SessionAdapter session = (SessionAdapter)login.getParent();
            session.addPropertyChangeListener("serverPlatform", this.serverPlatformListener);
            ServerPlatformAdapter serverPlatform = session.getServerPlatform();
            serverPlatform.addPropertyChangeListener("enableJTA", this.listener);
            if (!session.isBroker()) {
                DatabaseSessionAdapter databaseSession = (DatabaseSessionAdapter)session;
                databaseSession.addPropertyChangeListener("managedByBroker", this.managedListener);
                this.sessionBroker = databaseSession.getBroker();
            }
        }

        protected void initialize() {
            super.initialize();
            this.listener = this.buildPropertyChangeListener();
            this.managedListener = this.buildManagedPropertyChangeListener();
            this.serverPlatformListener = this.buildServerPlatformPropertyChangeListener();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            boolean oldEnabled = this.isEnabled();
            this.enabled = enabled;
            this.firePropertyChanged(ENABLED_PROPERTY, oldEnabled, enabled);
        }

        public void setParentNode(Node parentNode) {
            if (this.getParent() != null) {
                this.disengageListeners();
            }
            super.setParent(parentNode);
            if (parentNode != null) {
                this.engageListeners();
                this.updateEnableState();
            }
        }

        private void updateEnableState() {
            boolean enabled;
            DatabaseLoginAdapter login = (DatabaseLoginAdapter)this.getParent();
            DatabaseSessionAdapter session = (DatabaseSessionAdapter)login.getParent();
            boolean bl = enabled = login.databaseDriverIsDriverManager() && !session.hasJTA();
            if (session.isManaged() && session.getBroker().hasJTA()) {
                enabled = false;
            }
            this.setEnabled(enabled);
        }
    }

    private class CustomizedExternalOptionsPane
    extends LoginExternalOptionsPane {
        protected CustomizedExternalOptionsPane() {
            super(RdbmsConnectionPropertiesPage.this.getSelectionHolder(), RdbmsConnectionPropertiesPage.this.getApplicationContext());
        }

        @Override
        protected JCheckBox buildExternalConnectionPoolingCheckBox() {
            JCheckBox checkBox = super.buildExternalConnectionPoolingCheckBox();
            this.buildExternalConnectionPoolingEnabler(checkBox);
            return checkBox;
        }

        private ComponentEnabler buildExternalConnectionPoolingEnabler(JCheckBox checkBox) {
            return new ComponentEnabler((ValueModel)this.buildExternalConnectionPoolingEnableStateHolder(), Collections.singleton(checkBox));
        }

        private PropertyValueModel buildExternalConnectionPoolingEnableStateHolder() {
            return new PropertyAspectAdapter("enabled", (Model)RdbmsConnectionPropertiesPage.this.pseudoModel){

                @Override
                protected Object getValueFromSubject() {
                    PseudoExternalConnectionPoolingModel model = (PseudoExternalConnectionPoolingModel)((Object)this.subject);
                    return model.isEnabled();
                }
            };
        }
    }
}

