/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.testing.tests.validation.EmployeeWithProblems;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class SetMethodParameterTypeNotValidTest
extends ExceptionTest {
    IntegrityChecker orgIntegrityChecker;

    public SetMethodParameterTypeNotValidTest() {
        this.setDescription("This tests Set Method Parameter Type Not Valid (TL-ERROR 133) ");
    }

    protected void setup() {
        this.expectedException = DescriptorException.setMethodParameterTypeNotValid((CollectionMapping)new OneToManyMapping());
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
    }

    @Override
    public void reset() {
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            RelationalDescriptor descriptor = this.descriptor();
            OneToManyMapping dMapping = (OneToManyMapping)descriptor.getMappingForAttributeName("managedEmployeesWithProblems");
            EmployeeWithProblems person = new EmployeeWithProblems();
            NoIndirectionPolicy indirectionPolicy = (NoIndirectionPolicy)dMapping.getIndirectionPolicy();
            indirectionPolicy.validateSetMethodParameterTypeForCollection(EmployeeWithProblems.class, this.getSession().getIntegrityChecker());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmployeeWithProblems.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToManyMapping managedEmployeesMapping = new OneToManyMapping();
        managedEmployeesMapping.setAttributeName("managedEmployeesWithProblems");
        managedEmployeesMapping.setReferenceClass(EmployeeWithProblems.class);
        managedEmployeesMapping.dontUseIndirection();
        managedEmployeesMapping.setSetMethodName("setManagedEmployeesWithProblems");
        managedEmployeesMapping.addTargetForeignKeyFieldName("EMPLOYEE.MANAGER_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managedEmployeesMapping);
        return descriptor;
    }
}

