/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestEntity;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class TestExecutor {
    protected Writer log = new OutputStreamWriter(System.out);
    protected Writer regressionLog;
    protected Session session;
    protected EntityManagerFactory entityManagerFactory;
    protected Session originalSession;
    protected boolean shouldHandleErrors = false;
    protected boolean shouldLogResults = true;
    protected Hashtable loadedModels;
    protected Vector configuredSystems = new Vector();
    protected boolean shouldStopExecution = false;
    protected TestListener listener;
    protected static TestExecutor executor;
    protected static TestResult defaultJUnitTestResult;
    protected static Map junitTestResults;
    public boolean isServer = false;
    protected boolean shouldLogOnlyErrors = false;
    public static String CR;

    public static TestExecutor getDefaultExecutor() {
        if (executor == null) {
            TestExecutor testExecutor = new TestExecutor();
            testExecutor.setSession((Session)new TestSystem().login());
            executor = testExecutor;
        }
        return executor;
    }

    public boolean shouldLogOnlyErrors() {
        return this.shouldLogOnlyErrors;
    }

    public void setShouldLogOnlyErrors(boolean shouldLogOnlyErrors) {
        this.shouldLogOnlyErrors = shouldLogOnlyErrors;
    }

    public static void setDefaultExecutor(TestExecutor theExecutor) {
        executor = theExecutor;
    }

    public static void setDefaultJUnitTestResult(TestResult theTestResult) {
        defaultJUnitTestResult = theTestResult;
    }

    public static TestResult getDefaultJUnitTestResult() {
        return defaultJUnitTestResult;
    }

    public static void setJUnitTestResults(Map results) {
        junitTestResults = results;
    }

    public static Map getJUnitTestResults() {
        if (junitTestResults == null) {
            junitTestResults = new HashMap();
        }
        return junitTestResults;
    }

    public void addConfigureSystem(TestSystem system) {
        if (!this.configuredSystemsContainsInstanceOf(system)) {
            this.getConfiguredSystems().addElement(system);
        }
    }

    public void addLoadedModels(Vector models) {
        Enumeration theModels = models.elements();
        while (theModels.hasMoreElements()) {
            TestModel model = (TestModel)theModels.nextElement();
            this.getLoadedModels().put(model.getName(), model);
        }
    }

    public void configureSystem(TestSystem system) throws Exception {
        if (!this.configuredSystemsContainsInstanceOf(system)) {
            system.run(this.getSession());
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.getConfiguredSystems().addElement(system);
        }
    }

    public boolean configuredSystemsContainsInstanceOf(TestSystem system) {
        Enumeration configuredSystemsEnum = this.getConfiguredSystems().elements();
        while (configuredSystemsEnum.hasMoreElements()) {
            if (!configuredSystemsEnum.nextElement().getClass().equals(system.getClass())) continue;
            return true;
        }
        return false;
    }

    public void doNotHandleErrors() {
        this.setShouldHandleErrors(false);
    }

    public void doNotLogResults() {
        this.setShouldLogResults(false);
    }

    public void doNotStopExecution() {
        this.setShouldStopExecution(false);
    }

    public void execute(Test test) throws Throwable {
        if (this.shouldStopExecution()) {
            return;
        }
        try {
            this.getSession().logMessage("Begin " + test);
            if (this.getListener() != null) {
                this.getListener().startTest(test);
            }
            if (TestExecutor.getDefaultJUnitTestResult() != null || !(test instanceof TestEntity)) {
                TestResult result = TestExecutor.getDefaultJUnitTestResult();
                if (TestExecutor.getDefaultJUnitTestResult() == null) {
                    result = new TestResult();
                    result.addListener(this.getListener());
                    TestExecutor.getJUnitTestResults().put(test, result);
                }
                test.run(result);
            } else {
                ((TestEntity)test).execute(this);
            }
            if (this.getListener() != null) {
                this.getListener().endTest(test);
            }
            this.getSession().logMessage("Finished " + test);
            if (this.getAbstractSession().isInTransaction()) {
                throw new TestProblemException(test + " is a faulty test, transaction was left open and must always be closed.");
            }
        }
        catch (Throwable exception) {
            if (!(exception instanceof TestWarningException) && !this.shouldHandleErrors()) {
                throw exception;
            }
            if (this.getListener() != null) {
                this.getListener().endTest(test);
            }
            this.getSession().logMessage("Failed " + test);
        }
    }

    public void forceConfigureSystem(TestSystem system) throws Exception {
        this.removeConfigureSystem(system);
        system.run(this.getSession());
        this.addConfigureSystem(system);
    }

    public Vector getConfiguredSystems() {
        return this.configuredSystems;
    }

    public TestListener getListener() {
        return this.listener;
    }

    public TestModel getLoadedModel(String modelsName) {
        return (TestModel)this.getLoadedModels().get(modelsName);
    }

    public Hashtable getLoadedModels() {
        return this.loadedModels;
    }

    public Writer getRegressionLog() {
        return this.regressionLog;
    }

    public Writer getLog() {
        if (this.getSession() == null) {
            return this.log;
        }
        return this.getSession().getLog();
    }

    public EntityManager createEntityManager() {
        return this.getEntityManagerFactory().createEntityManager();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.entityManagerFactory == null) {
            Map properties = this.getEntityManagerProperties();
            this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"performance", (Map)properties);
        }
        return this.entityManagerFactory;
    }

    public Map getEntityManagerProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.jdbc.driver", this.getSession().getLogin().getDriverClassName());
        properties.put("javax.persistence.jdbc.url", this.getSession().getLogin().getConnectionString());
        properties.put("javax.persistence.jdbc.user", this.getSession().getLogin().getUserName());
        properties.put("javax.persistence.jdbc.password", this.getSession().getLogin().getPassword());
        properties.put("eclipselink.logging.level", this.getSession().getSessionLog().getLevelString());
        return properties;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public DatabaseSession getDatabaseSession() {
        return (DatabaseSession)this.getSession();
    }

    public AbstractSession getAbstractSession() {
        return (AbstractSession)this.getSession();
    }

    public Session getSession() {
        return this.session;
    }

    public Session getOriginalSession() {
        return this.originalSession;
    }

    public void setOriginalSession(Session originalSession) {
        this.originalSession = originalSession;
    }

    public void swapSession(Session newSession) {
        this.setOriginalSession(this.getSession());
        this.setSession(newSession);
    }

    public void swapCleanDatabaseSession() {
        DatabaseSession session = new Project(this.getSession().getLogin()).createDatabaseSession();
        session.setSessionLog(this.getSession().getSessionLog());
        session.login();
        this.swapSession((Session)session);
    }

    public void swapServerSession() {
        Server session = this.getSession().getProject().createServerSession();
        session.setSessionLog(this.getSession().getSessionLog());
        session.login();
        this.swapSession((Session)session);
    }

    public void resetSession() {
        if (this.getOriginalSession() != null) {
            if (this.getDatabaseSession().isConnected()) {
                this.getDatabaseSession().logout();
            }
            this.setSession(this.getOriginalSession());
            this.setOriginalSession(null);
        }
    }

    public void handleErrors() {
        this.setShouldHandleErrors(true);
    }

    public void initializeConfiguredSystems() {
        this.setConfiguredSystems(new Vector());
    }

    protected void logout() {
        if (this.session != null) {
            ((DatabaseSession)this.session).logout();
        }
    }

    public void logRegressionResultForTestEntity(Test test) {
        this.logResultForTestEntity(test, true);
    }

    public void logResultForTestEntity(Test test) {
        this.logResultForTestEntity(test, false);
    }

    public void logResultForTestEntity(Test test, boolean regression) {
        Writer log = this.getLog();
        if (regression) {
            log = this.getRegressionLog();
        }
        if (this.shouldStopExecution()) {
            try {
                log.write("!!! THE TEST EXECUTION WAS INTERRUPTED !!!");
                log.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.shouldLogResults()) {
            if (test instanceof TestEntity) {
                TestEntity testEntity = (TestEntity)test;
                testEntity.resetNestedCounter();
                if (regression) {
                    testEntity.logRegressionResult(log);
                } else {
                    testEntity.logResult(log, this.shouldLogOnlyErrors());
                }
                testEntity.resetNestedCounter();
            } else {
                TestExecutor.logJUnitResult(test, log, "");
            }
        }
        try {
            log.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void logJUnitResult(Test test, Writer log, String indent) {
        try {
            int startIndex;
            String testString;
            log.write(CR);
            log.write(CR);
            log.write(indent + "TEST MODEL NAME: (JUnit test): " + test);
            log.write(CR);
            TestResult result = (TestResult)TestExecutor.getJUnitTestResults().get(test);
            if (result == null) {
                log.write(indent + "## SETUP FAILURE ## (no tests run)");
                log.write(CR);
                log.flush();
                return;
            }
            if (result.failureCount() > 0 || result.errorCount() > 0) {
                log.write(indent + "###ERRORS###" + CR);
            }
            log.write(CR);
            log.write(indent + "Errors: (failures): " + result.failureCount());
            log.write(CR);
            log.write(indent + "Fatal Errors: (errors): " + result.errorCount());
            log.write(CR);
            log.write(indent + "Passed: " + (result.runCount() - result.errorCount() - result.failureCount()));
            log.write(CR);
            log.write(indent + "Total Tests: " + result.runCount());
            log.write(CR);
            if (result.failureCount() > 0) {
                log.write(CR);
                log.write(indent + "Failures:");
                log.write(CR);
                Enumeration failures = result.failures();
                while (failures.hasMoreElements()) {
                    TestFailure failure = (TestFailure)failures.nextElement();
                    testString = failure.failedTest().toString();
                    startIndex = testString.indexOf("(");
                    if (startIndex != -1) {
                        log.write(indent + "TEST SUITE NAME: " + testString.substring(startIndex + 1, testString.length() - 1));
                        log.write(CR);
                    }
                    log.write(indent + "TEST NAME: " + testString);
                    log.write(CR);
                    log.write(indent + "##FAILURE##" + CR);
                    log.write(indent + "RESULT:      Error (failure)");
                    log.write(CR);
                    log.write(indent + failure.trace());
                    log.write(CR);
                }
            }
            if (result.errorCount() > 0) {
                log.write(CR);
                log.write(indent + "Errors:");
                log.write(CR);
                Enumeration errors = result.errors();
                while (errors.hasMoreElements()) {
                    TestFailure error = (TestFailure)errors.nextElement();
                    testString = error.failedTest().toString();
                    startIndex = testString.indexOf("(");
                    if (startIndex != -1) {
                        log.write(indent + "TEST SUITE NAME: " + testString.substring(startIndex + 1, testString.length() - 1));
                        log.write(CR);
                    }
                    log.write(indent + "TEST NAME: " + testString);
                    log.write(CR);
                    log.write(indent + "##FAILURE##" + CR);
                    log.write(indent + "RESULT:      FatalError (error)");
                    log.write(CR);
                    log.write(indent + error.trace());
                    log.write(CR);
                }
            }
            log.write(CR);
            log.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void logResults() {
        this.setShouldLogResults(true);
    }

    public static void main(String[] arguments) {
        try {
            TestExecutor executor = new TestExecutor();
            executor.execute((TestEntity)Class.forName(arguments[0]).newInstance());
        }
        catch (Throwable exception) {
            System.out.println(exception.toString());
        }
    }

    public void removeConfigureSystem(TestSystem system) {
        this.removeFromConfiguredSystemsInstanceOf(system);
    }

    public void removeFromConfiguredSystemsInstanceOf(TestSystem system) {
        Vector<TestSystem> systemsToRemove = new Vector<TestSystem>();
        Enumeration systemEnum = this.getConfiguredSystems().elements();
        while (systemEnum.hasMoreElements()) {
            TestSystem aSystem = (TestSystem)systemEnum.nextElement();
            if (!aSystem.getClass().equals(system.getClass())) continue;
            systemsToRemove.addElement(aSystem);
        }
        Enumeration systemsToRemoveEnum = systemsToRemove.elements();
        while (systemsToRemoveEnum.hasMoreElements()) {
            this.getConfiguredSystems().removeElement(systemsToRemoveEnum.nextElement());
        }
    }

    public void resetLoadedModels() {
        this.setLoadedModels(new Hashtable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(Test test) throws Throwable {
        boolean hasSession = true;
        this.setShouldStopExecution(false);
        if (this.getSession() == null && test instanceof TestEntity) {
            TestEntity testEntity = (TestEntity)test;
            hasSession = false;
            if (this.shouldHandleErrors()) {
                try {
                    this.setSession(testEntity.defaultLogin());
                }
                catch (Exception exception) {
                    this.logout();
                    return;
                }
            } else {
                this.setSession(testEntity.defaultLogin());
            }
        }
        try {
            this.execute(test);
            if (this.getRegressionLog() != null) {
                this.logRegressionResultForTestEntity(test);
            }
            this.logResultForTestEntity(test);
        }
        finally {
            if (!hasSession) {
                this.logout();
            }
        }
    }

    public void setConfiguredSystems(Vector configuredSystems) {
        this.configuredSystems = configuredSystems;
    }

    public void setListener(TestListener listener) {
        this.listener = listener;
    }

    protected void setLoadedModels(Hashtable loadedModels) {
        this.loadedModels = loadedModels;
    }

    public void setRegressionLog(Writer writer) {
        this.regressionLog = writer;
    }

    public void setLog(Writer writer) {
        this.log = writer;
    }

    public void setSession(Session theSession) {
        if (theSession == null) {
            return;
        }
        this.session = theSession;
    }

    public void setShouldHandleErrors(boolean aBoolean) {
        this.shouldHandleErrors = aBoolean;
    }

    public void setShouldLogResults(boolean aBoolean) {
        this.shouldLogResults = aBoolean;
    }

    public void setShouldStopExecution(boolean aBoolean) {
        this.shouldStopExecution = aBoolean;
    }

    public boolean shouldHandleErrors() {
        return this.shouldHandleErrors;
    }

    public boolean shouldLogResults() {
        return this.shouldLogResults;
    }

    public boolean shouldStopExecution() {
        return this.shouldStopExecution;
    }

    public void stopExecution() {
        this.setShouldStopExecution(true);
    }

    static {
        CR = Helper.cr();
    }
}

