/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.mappings;

import org.eclipse.persistence.annotations.VirtualAccessMethods;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class AccessMethodsMetadata
extends ORMetadata {
    String getMethodName = "get";
    String setMethodName = "set";

    public AccessMethodsMetadata(MetadataAnnotation virtualAccessMethods, MetadataAccessor accessor) {
        super(virtualAccessMethods, accessor);
        if (virtualAccessMethods.getName().equals(VirtualAccessMethods.class.getName())) {
            if (virtualAccessMethods.hasAttribute("get")) {
                this.getMethodName = virtualAccessMethods.getAttributeString("get");
            }
            if (virtualAccessMethods.hasAttribute("set")) {
                this.setMethodName = virtualAccessMethods.getAttributeString("set");
            }
        }
    }

    public AccessMethodsMetadata() {
        super("<access-methods>");
    }

    public AccessMethodsMetadata clone() {
        AccessMethodsMetadata accessMethods = new AccessMethodsMetadata();
        accessMethods.setGetMethodName(this.getGetMethodName());
        accessMethods.setSetMethodName(this.getSetMethodName());
        return accessMethods;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof AccessMethodsMetadata) {
            AccessMethodsMetadata accessMethods = (AccessMethodsMetadata)objectToCompare;
            if (!this.valuesMatch(this.getMethodName, accessMethods.getGetMethodName())) {
                return false;
            }
            return this.valuesMatch(this.setMethodName, accessMethods.getSetMethodName());
        }
        return false;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public void setGetMethodName(String getMethodName) {
        this.getMethodName = getMethodName;
    }

    public void setSetMethodName(String setMethodName) {
        this.setMethodName = setMethodName;
    }

    public String toString() {
        return "Get method name: " + this.getMethodName + ", Set method name: " + this.setMethodName;
    }
}

