/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWClassIndicatorExtractionMethodPolicy
extends MWAbstractClassIndicatorPolicy {
    private MWMethodHandle methodHandle;
    public static final String METHOD_PROPERTY = "classExtractionMethod";

    private MWClassIndicatorExtractionMethodPolicy() {
    }

    public MWClassIndicatorExtractionMethodPolicy(MWClassIndicatorPolicy.Parent parent) {
        super(parent);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.methodHandle = new MWMethodHandle(this, this.buildMethodScrubber());
    }

    @Override
    public String getType() {
        return "classExtractionMethodClassIndicatorPolicy";
    }

    public MWMethod getClassExtractionMethod() {
        return this.methodHandle.getMethod();
    }

    public void setClassExtractionMethod(MWMethod classExtractionMethod) {
        MWMethod old = this.getClassExtractionMethod();
        this.methodHandle.setMethod(classExtractionMethod);
        this.firePropertyChanged(METHOD_PROPERTY, old, classExtractionMethod);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.methodHandle);
    }

    private MWHandle.NodeReferenceScrubber buildMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWClassIndicatorExtractionMethodPolicy.this.setClassExtractionMethod(null);
            }

            public String toString() {
                return "MWClassIndicatorExtractionMethodPolicy.buildMethodScrubber()";
            }
        };
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkClassExtractionMethod(newProblems);
    }

    private void checkClassExtractionMethod(List newProblems) {
        if (this.getClassExtractionMethod() == null) {
            newProblems.add(this.buildProblem("0327"));
        } else if (!CollectionTools.contains(this.getContainingDescriptor().getMWClass().methods(), (Object)this.getClassExtractionMethod())) {
            newProblems.add(this.buildProblem("0328"));
        } else if (!this.getClassExtractionMethod().isCandidateClassExtractionMethod()) {
            newProblems.add(this.buildProblem("0329"));
        }
    }

    @Override
    public void adjustRuntimeInheritancePolicy(InheritancePolicy runtimeInheritancePolicy) {
        if (this.getClassExtractionMethod() != null) {
            runtimeInheritancePolicy.setClassExtractionMethodName(this.getClassExtractionMethod().getName());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWClassIndicatorExtractionMethodPolicy.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractClassIndicatorPolicy.class);
        XMLCompositeObjectMapping classExtractionMethodHandleMapping = new XMLCompositeObjectMapping();
        classExtractionMethodHandleMapping.setAttributeName("methodHandle");
        classExtractionMethodHandleMapping.setGetMethodName("getMethodHandleForTopLink");
        classExtractionMethodHandleMapping.setSetMethodName("setMethodHandleForTopLink");
        classExtractionMethodHandleMapping.setReferenceClass(MWMethodHandle.class);
        classExtractionMethodHandleMapping.setXPath("method-handle");
        descriptor.addMapping((DatabaseMapping)classExtractionMethodHandleMapping);
        return descriptor;
    }

    private MWMethodHandle getMethodHandleForTopLink() {
        return this.methodHandle.getMethod() == null ? null : this.methodHandle;
    }

    private void setMethodHandleForTopLink(MWMethodHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildMethodScrubber();
        this.methodHandle = handle == null ? new MWMethodHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

