/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWQueryableHandle
extends MWHandle {
    private volatile MWQueryable queryable;
    private volatile String mappingDescriptorName;
    private volatile String queryableName;

    private MWQueryableHandle() {
    }

    public MWQueryableHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWQueryableHandle(MWModel parent, MWQueryable queryable, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.queryable = queryable;
    }

    public MWQueryable getQueryable() {
        return this.queryable;
    }

    public void setQueryable(MWQueryable queryable) {
        this.queryable = queryable;
    }

    @Override
    protected Node node() {
        return this.getQueryable();
    }

    public MWQueryableHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    @Override
    public void postProjectBuild() {
        MWRelationalClassDescriptor mappingDescriptor;
        super.postProjectBuild();
        if (this.mappingDescriptorName != null && this.queryableName != null && (mappingDescriptor = (MWRelationalClassDescriptor)this.getProject().descriptorNamed(this.mappingDescriptorName)) != null) {
            this.queryable = mappingDescriptor.queryableNamed(this.queryableName);
        }
        this.mappingDescriptorName = null;
        this.queryableName = null;
    }

    public int compareTo(Object o) {
        return this.queryable.compareTo(((MWQueryableHandle)o).queryable);
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.queryable == null ? "null" : this.queryable.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWQueryableHandle.class);
        descriptor.addDirectMapping("mappingDescriptorName", "getMappingDescriptorNameForToplink", "setMappingDescriptorNameForToplink", "mapping-descriptor-name/text()");
        descriptor.addDirectMapping("queryableName", "getQueryableNameForToplink", "setQueryableNameForToplink", "queryable-name/text()");
        return descriptor;
    }

    private String getMappingDescriptorNameForToplink() {
        return this.queryable == null ? null : this.queryable.getParentDescriptor().getName();
    }

    private void setMappingDescriptorNameForToplink(String mappingDescriptorName) {
        this.mappingDescriptorName = mappingDescriptorName;
    }

    private String getQueryableNameForToplink() {
        return this.queryable == null ? null : this.queryable.getName();
    }

    private void setQueryableNameForToplink(String queryableName) {
        this.queryableName = queryableName;
    }
}

