/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TransformerCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;

public abstract class FieldTransformerAssociationsPanel
extends AbstractSubjectPanel {
    private ObjectListSelectionModel fieldTransformerAssociationsSelectionModel;

    public FieldTransformerAssociationsPanel(ValueModel transformationMappingHolder, WorkbenchContextHolder contextHolder) {
        super(transformationMappingHolder, contextHolder);
    }

    @Override
    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("TRANSFORMATION_MAPPING_FIELD_TRANSFORMER_ASSOCIATIONS_PANEL")));
        GridBagConstraints constraints = new GridBagConstraints();
        JComponent tablePanel = this.buildFieldTransformerAssociationsTablePanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)tablePanel, constraints);
        JButton addButton = this.buildAddFieldTransformerAssociationButton();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)addButton, constraints);
        this.addAlignRight(addButton);
        JButton editButton = this.buildEditFieldTransformerAssociationButton();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)editButton, constraints);
        this.addAlignRight(editButton);
        JButton removeButton = this.buildRemoveFieldTransformerAssociationsButton();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)removeButton, constraints);
        this.addAlignRight(removeButton);
        this.addHelpTopicId(this, "mapping.transformation.fieldTransformerAssociations");
    }

    private JComponent buildFieldTransformerAssociationsTablePanel() {
        JTable table = this.buildFieldTransformerAssociationsTable();
        TableColumn firstColumn = table.getColumnModel().getColumn(0);
        TableColumn secondColumn = table.getColumnModel().getColumn(1);
        secondColumn.setPreferredWidth(firstColumn.getPreferredWidth() * 2);
        JScrollPane scrollPane = new JScrollPane(table, 20, 31);
        scrollPane.getViewport().setBackground(table.getBackground());
        scrollPane.setPreferredSize(new Dimension(10, 10));
        return scrollPane;
    }

    private JTable buildFieldTransformerAssociationsTable() {
        ListValueModel listValue = this.buildFieldTransformerAssociationsValue();
        TableModel tableModel = this.buildFieldTransformerAssociationsTableModel(listValue);
        this.fieldTransformerAssociationsSelectionModel = this.buildFieldTransformerAssociationsSelectionModel(listValue);
        JTable table = SwingComponentFactory.buildTable(tableModel, this.fieldTransformerAssociationsSelectionModel);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setCellRenderer(this.buildFieldColumnCellRenderer());
        column = table.getColumnModel().getColumn(1);
        column.setCellRenderer(this.buildTransformerTableCellRenderer());
        return table;
    }

    private ListValueModel buildFieldTransformerAssociationsValue() {
        return new ListAspectAdapter(this.getSubjectHolder(), "fieldTransformerAssociations"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWTransformationMapping)this.subject).fieldTransformerAssociations();
            }
        };
    }

    private TableModel buildFieldTransformerAssociationsTableModel(ListValueModel sortedFieldTransformerAssociationsValue) {
        return new TableModelAdapter(sortedFieldTransformerAssociationsValue, this.buildFieldTransformerAssociationsColumnAdapter());
    }

    protected ColumnAdapter buildFieldTransformerAssociationsColumnAdapter() {
        return new FieldTransformationAssociationsColumnAdapter(this.resourceRepository());
    }

    private ObjectListSelectionModel buildFieldTransformerAssociationsSelectionModel(ListValueModel sortedFieldTransformerAssociationsValue) {
        ObjectListSelectionModel selectionModel = new ObjectListSelectionModel(new ListModelAdapter(sortedFieldTransformerAssociationsValue));
        selectionModel.setSelectionMode(2);
        return selectionModel;
    }

    protected TableCellRenderer buildFieldColumnCellRenderer() {
        return new SimpleTableCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return value == null ? null : ((MWDataField)value).fieldName();
            }
        };
    }

    private TableCellRenderer buildTransformerTableCellRenderer() {
        return new AdaptableTableCellRenderer(new TransformerCellRendererAdapter(this.resourceRepository()));
    }

    private JButton buildAddFieldTransformerAssociationButton() {
        JButton button = new JButton(this.resourceRepository().getString("TRANSFORMATION_MAPPING_FIELD_TRANSFORMER_ADD_BUTTON"));
        button.addActionListener(this.buildAddFieldTransformerAssociationAction());
        return button;
    }

    protected abstract ActionListener buildAddFieldTransformerAssociationAction();

    private JButton buildEditFieldTransformerAssociationButton() {
        JButton button = new JButton(this.resourceRepository().getString("TRANSFORMATION_MAPPING_FIELD_TRANSFORMER_EDIT_BUTTON"));
        button.addActionListener(this.buildEditFieldTransformerAssociationAction());
        this.fieldTransformerAssociationsSelectionModel.addListSelectionListener(this.buildListenerForEditFieldTransformerAssociation(button));
        button.setEnabled(false);
        return button;
    }

    protected abstract ActionListener buildEditFieldTransformerAssociationAction();

    private ListSelectionListener buildListenerForEditFieldTransformerAssociation(final JButton editButton) {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    boolean ableToEdit = FieldTransformerAssociationsPanel.this.fieldTransformerAssociationsSelectionModel.getSelectedValues().length == 1;
                    editButton.setEnabled(ableToEdit);
                }
            }
        };
    }

    private JButton buildRemoveFieldTransformerAssociationsButton() {
        JButton button = new JButton(this.resourceRepository().getString("TRANSFORMATION_MAPPING_FIELD_TRANSFORMERS_REMOVE_BUTTON"));
        button.addActionListener(this.buildRemoveFieldTransformerAssociationsAction());
        this.fieldTransformerAssociationsSelectionModel.addListSelectionListener(this.buildListenerForRemoveFieldTransformerAssociations(button));
        button.setEnabled(false);
        return button;
    }

    private ActionListener buildRemoveFieldTransformerAssociationsAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldTransformerAssociationsPanel.this.removeSelectedFieldTransformerAssociations();
            }
        };
    }

    private ListSelectionListener buildListenerForRemoveFieldTransformerAssociations(final JButton removeButton) {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    boolean ableToRemove = !FieldTransformerAssociationsPanel.this.fieldTransformerAssociationsSelectionModel.isSelectionEmpty();
                    removeButton.setEnabled(ableToRemove);
                }
            }
        };
    }

    private void removeSelectedFieldTransformerAssociations() {
        Iterator stream = CollectionTools.iterator((Object[])this.fieldTransformerAssociationsSelectionModel.getSelectedValues());
        while (stream.hasNext()) {
            ((MWTransformationMapping)this.subject()).removeFieldTransformerAssociation((MWFieldTransformerAssociation)stream.next());
        }
    }

    protected MWFieldTransformerAssociation selectedFieldTransformerAssociation() {
        return (MWFieldTransformerAssociation)this.fieldTransformerAssociationsSelectionModel.getSelectedValue();
    }

    protected static class FieldTransformationAssociationsColumnAdapter
    implements ColumnAdapter {
        protected ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int FIELD_COLUMN = 0;
        public static final int TRANSFORMER_COLUMN = 1;

        @Override
        public int getColumnCount() {
            return 2;
        }

        protected FieldTransformationAssociationsColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        @Override
        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return this.resourceRepository.getString("TRANSFORMATION_MAPPING_FIELD_COLUMN_LABEL");
                }
                case 1: {
                    return this.resourceRepository.getString("TRANSFORMATION_MAPPING_TRANSFORMER_COLUMN_LABEL");
                }
            }
            return "";
        }

        @Override
        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return MWDataField.class;
                }
                case 1: {
                    return MWTransformer.class;
                }
            }
            return null;
        }

        @Override
        public boolean isColumnEditable(int index) {
            return false;
        }

        @Override
        public PropertyValueModel[] cellModels(Object subject) {
            MWFieldTransformerAssociation association = (MWFieldTransformerAssociation)subject;
            PropertyValueModel[] cellModels = new PropertyValueModel[]{this.buildFieldAdapter(association), this.buildTransformerAdapter(association)};
            return cellModels;
        }

        protected PropertyValueModel buildFieldAdapter(MWFieldTransformerAssociation association) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("field", (Model)association){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWFieldTransformerAssociation)this.subject).getField();
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "fieldName");
        }

        private PropertyValueModel buildTransformerAdapter(MWFieldTransformerAssociation association) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("fieldTransformer", (Model)association){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWFieldTransformerAssociation)this.subject).getFieldTransformer();
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "transformer");
        }
    }
}

