/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.SessionCreationDialog;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class AddNewSessionAction
extends AbstractFrameworkAction {
    private final boolean selectNode;

    public AddNewSessionAction(WorkbenchContext context) {
        this(context, true);
    }

    public AddNewSessionAction(WorkbenchContext context, boolean selectNode) {
        super(context);
        this.selectNode = selectNode;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeText("ADD_SESSION");
        this.initializeMnemonic("ADD_SESSION");
        this.initializeIcon("ADD_SESSION");
        this.initializeToolTipText("ADD_SESSION.TOOL_TIP");
    }

    @Override
    protected void execute(ApplicationNode selectedNode) {
        TopLinkSessionsAdapter sessions = (TopLinkSessionsAdapter)selectedNode.getValue();
        SessionCreationDialog dialog = new SessionCreationDialog(this.getWorkbenchContext(), sessions.getAllSessionsNames());
        dialog.show();
        if (dialog.wasCanceled()) {
            return;
        }
        this.navigatorSelectionModel().pushExpansionState();
        SessionAdapter newSession = dialog.addNewSessionTo(sessions);
        this.navigatorSelectionModel().popAndRestoreExpansionState();
        if (this.selectNode) {
            ((AbstractApplicationNode)selectedNode.getProjectRoot()).selectDescendantNodeForValue((Node)newSession, this.navigatorSelectionModel());
        }
    }

    @Override
    public void execute() {
        super.execute();
    }
}

