/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.generation.MWDescriptorGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.generation.MWRelationshipHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DescriptorGenerationDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.RelationshipGenerationDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class DescriptorGenerationCoordinator {
    private WorkbenchContext context;

    DescriptorGenerationCoordinator(WorkbenchContext context) {
        this.initialize(context);
    }

    private void initialize(WorkbenchContext context) {
        this.context = context;
    }

    private Vector calculatePossibleRelationships(Collection tables) {
        Vector<MWRelationshipHolder> possibleRelationships = new Vector<MWRelationshipHolder>();
        Iterator tableIt = tables.iterator();
        while (tableIt.hasNext()) {
            Iterator references = ((MWTable)tableIt.next()).references();
            while (references.hasNext()) {
                MWReference reference = (MWReference)references.next();
                if (!reference.isForeignKeyReference() || !tables.contains(reference.getTargetTable())) continue;
                possibleRelationships.add(new MWRelationshipHolder(reference, false));
                possibleRelationships.add(new MWRelationshipHolder(reference, true));
            }
        }
        return possibleRelationships;
    }

    private boolean checkForProjectSave(RelationalProjectNode projectNode) {
        if (projectNode.isDirty()) {
            return this.promptToSaveProject(projectNode);
        }
        return true;
    }

    void generateClassDescriptorsForAllTables(RelationalProjectNode projectNode) {
        this.generateClassDescriptorsForTables(projectNode, CollectionTools.collection((Iterator)projectNode.getProject().getDatabase().tables()));
    }

    void generateClassDescriptorsForSelectedTables(RelationalProjectNode projectNode, Collection selectedTables) {
        this.generateClassDescriptorsForTables(projectNode, selectedTables);
    }

    private void generateClassDescriptorsForTables(RelationalProjectNode projectNode, Collection tables) {
        this.generateDescriptorsForTables(projectNode, tables);
    }

    private void generateDescriptorsForTables(RelationalProjectNode projectNode, Collection tables) {
        if (!this.checkForProjectSave(projectNode)) {
            return;
        }
        DescriptorGenerationDialog descriptorDialog = new DescriptorGenerationDialog((MWRelationalProject)projectNode.getProject(), this.context);
        descriptorDialog.show();
        if (descriptorDialog.wasCanceled()) {
            return;
        }
        Vector possibleRelationships = new Vector();
        Collection relationshipsToCreate = new Vector();
        boolean generateBidirectionalRelationships = false;
        if (!possibleRelationships.isEmpty()) {
            RelationshipGenerationDialog relationshipDialog = new RelationshipGenerationDialog(possibleRelationships, this.context);
            relationshipDialog.show();
            if (relationshipDialog.wasCanceled()) {
                return;
            }
            relationshipsToCreate = relationshipDialog.getRelationshipsToCreate();
            generateBidirectionalRelationships = relationshipDialog.getGenerateBidirectionalRelationships();
        }
        MWDescriptorGenerator generator = new MWDescriptorGenerator();
        generator.setProject((MWRelationalProject)projectNode.getProject());
        generator.setTables(tables);
        generator.setPackageName(descriptorDialog.getPackageName());
        generator.setGenerateMethodAccessors(descriptorDialog.getGenerateAccessors());
        generator.setGenerateBidirectionalRelationships(generateBidirectionalRelationships);
        generator.setRelationshipsToCreate(relationshipsToCreate);
        generator.generateClassesAndDescriptors();
        String successDialogString = "generateClassesAndDescriptors";
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString(successDialogString + ".message"), this.resourceRepository().getString(successDialogString + ".title"), 1);
    }

    private boolean promptToSaveProject(RelationalProjectNode projectNode) {
        int selection = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("autoGeneratingClassAndDescriptor.message"), this.resourceRepository().getString("saveProject.title"), 1, 1);
        if (selection == 0) {
            if (projectNode.save(null, this.context)) {
                return true;
            }
            JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("saveProjectError.message"), this.resourceRepository().getString("unableToCreateClassesAndDescriptors.title"), 1);
            return false;
        }
        return selection != 2 && selection != -1;
    }

    private ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }
}

