/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.was;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.server.ServerPlatformDetector;

public class WebSpherePlatformDetector
implements ServerPlatformDetector {
    private static final String[] LIBERTY_PROPS = new String[]{"server.config.dir", "server.output.dir"};
    private static final String FULL_PROFILE_WAS_DIR_CLS = "com.ibm.websphere.product.WASDirectory";

    @Override
    public String checkPlatform() {
        if (this.isLiberty()) {
            return "WebSphere_Liberty";
        }
        if (this.isFullProfile()) {
            return "WebSphere_7";
        }
        return null;
    }

    private boolean isLiberty() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return WebSpherePlatformDetector.this.isLibertyInternal();
                }
            });
        }
        return this.isLibertyInternal();
    }

    private boolean isFullProfile() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return WebSpherePlatformDetector.this.isFullProfileInternal();
                }
            });
        }
        return this.isFullProfileInternal();
    }

    private Boolean isLibertyInternal() {
        String[] stringArray = LIBERTY_PROPS;
        int n = LIBERTY_PROPS.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            if (System.getProperty(prop) == null) {
                return Boolean.FALSE;
            }
            ++n2;
        }
        return Boolean.TRUE;
    }

    private Boolean isFullProfileInternal() {
        try {
            ClassLoader loader = WebSpherePlatformDetector.class.getClassLoader();
            Class<?> cls = loader.loadClass(FULL_PROFILE_WAS_DIR_CLS);
            Object instance = cls.newInstance();
            if (instance != null) {
                return Boolean.TRUE;
            }
        }
        catch (Throwable throwable) {}
        return Boolean.FALSE;
    }
}

