/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class CompareArrayLengthTest
extends AutoVerifyTestCase {
    Exception e;
    Integer[] array1 = new Integer[2];
    Integer[] array2 = new Integer[2];
    Integer[] array3 = new Integer[3];
    boolean test1ResultIsTrue = false;
    boolean test2ResultIsTrue = false;

    public CompareArrayLengthTest() {
        this.setDescription("Test of Helper.compareArrays(Object[] array1, Object[] array2) method's comparison of object array length.");
    }

    public static void main(String[] args) {
        CompareArrayLengthTest x = new CompareArrayLengthTest();
        x.setup();
        x.test();
        x.verify();
        x.reset();
    }

    public void reset() {
        this.array1 = null;
        this.array2 = null;
        this.array3 = null;
    }

    public void setup() {
        for (int count = 0; count < 2; ++count) {
            Integer counter;
            this.array1[count] = counter = new Integer(count);
            this.array2[count] = counter;
            this.array3[count] = counter;
        }
        this.array3[2] = new Integer(10);
    }

    public void test() {
        try {
            this.test1ResultIsTrue = Helper.compareArrays((Object[])this.array1, (Object[])this.array2);
            this.test2ResultIsTrue = Helper.compareArrays((Object[])this.array1, (Object[])this.array3);
        }
        catch (Exception e) {
            this.e = e;
            throw new TestErrorException("An exception should not have been thrown when comparing object array length.");
        }
    }

    public void verify() {
        if (!this.test1ResultIsTrue) {
            throw new TestErrorException("Helper.compareArrays(Object[] array1, Object[] array2) does not recognize that object arrays are of same length.");
        }
        if (this.test2ResultIsTrue) {
            throw new TestErrorException("Helper.compareArrays(Object[] array1, Object[] array2) does not recognize that object arrays are of different length.");
        }
        if (this.e != null) {
            throw new TestErrorException("An exception should not have been thrown when comparing array length: " + this.e.toString());
        }
    }
}

