/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.history;

import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeTableCreator;
import org.eclipse.persistence.testing.tests.history.HistoryTestModel;
import org.eclipse.persistence.testing.tests.workbenchintegration.WorkbenchIntegrationSystemHelper;
import org.eclipse.persistence.tools.history.HistoryFacade;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableCreator;

public class HistoricalEmployeeSystem
extends EmployeeSystem {
    int mode;

    public HistoricalEmployeeSystem(int mode) {
        this("MWIntegrationTestHistoricalEmployeeProject", mode);
    }

    public HistoricalEmployeeSystem(String fileName, int mode) {
        this.mode = mode;
        this.initializeProject(this.getInitialProject(), fileName);
    }

    public void initializeProject(Project initialProject, String fileName) {
        if (this.mode == HistoryTestModel.BASIC) {
            this.project = initialProject;
        } else if (this.mode == HistoryTestModel.PROJECT_XML) {
            this.project = WorkbenchIntegrationSystemHelper.buildProjectXML(initialProject, fileName);
        } else if (this.mode == HistoryTestModel.PROJECT_CLASS_GENERATED) {
            this.project = WorkbenchIntegrationSystemHelper.buildProjectClass(initialProject, fileName);
        }
    }

    public Project getInitialProject() {
        EmployeeProject initialProject = new EmployeeProject();
        HistoryFacade.generateHistoryPolicies(initialProject);
        return initialProject;
    }

    @Override
    public void createTables(DatabaseSession session) {
        if (!SchemaManager.FAST_TABLE_CREATOR) {
            if (session.getPlatform().isOracle()) {
                this.executeCall(session, "drop table PHONE CASCADE CONSTRAINTS");
                this.executeCall(session, "drop table RESPONS CASCADE CONSTRAINTS");
                this.executeCall(session, "drop table SALARY CASCADE CONSTRAINTS");
                this.executeCall(session, "drop table PROJ_EMP CASCADE CONSTRAINTS");
                this.executeCall(session, "drop table LPROJECT CASCADE CONSTRAINTS");
                this.executeCall(session, "drop table PROJECT CASCADE CONSTRAINTS");
                this.executeCall(session, "drop table EMPLOYEE CASCADE CONSTRAINTS");
                this.executeCall(session, "drop table ADDRESS CASCADE CONSTRAINTS");
            } else {
                this.executeCall(session, "drop table PHONE");
                this.executeCall(session, "drop table RESPONS");
                this.executeCall(session, "drop table SALARY");
                this.executeCall(session, "drop table PROJ_EMP");
                this.executeCall(session, "drop table LPROJECT");
                this.executeCall(session, "drop table PROJECT");
                this.executeCall(session, "drop table EMPLOYEE");
                this.executeCall(session, "drop table ADDRESS");
            }
        }
        EmployeeTableCreator creator = new EmployeeTableCreator();
        HistoryFacade.generateHistoricalTableDefinitions((TableCreator)creator, (Session)session);
        creator.resetFastTableCreator();
        creator.replaceTables(session);
    }

    private void executeCall(DatabaseSession session, String call) {
        try {
            session.executeNonSelectingCall((Call)new SQLCall(call));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

