/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.isolatedsession.ClientServerTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee;

public class VerifyQueryCacheIsolated
extends ClientServerTest {
    protected Vector readEmployees = null;
    protected ReadAllQuery query = null;
    protected Session session = null;

    public VerifyQueryCacheIsolated(boolean isExclusive) {
        super(isExclusive);
        this.setDescription("This test verifies that certain data from a query cache is only available to the client");
    }

    @Override
    public void setup() {
        super.setup();
        this.query = new ReadAllQuery(IsolatedEmployee.class);
        this.query.cacheQueryResults();
    }

    @Override
    public void test() {
        this.session = (Session)this.clients.get(0);
        if (!(this.session instanceof IsolatedClientSession)) {
            throw new TestErrorException("The session created was not an Isolated Session");
        }
        this.session.executeQuery((DatabaseQuery)this.query);
        this.readEmployees = (Vector)this.session.executeQuery((DatabaseQuery)this.query);
    }

    @Override
    public void verify() {
        if (this.server.getIdentityMapAccessorInstance().getQueryResult((ReadQuery)this.query, null, false) != null) {
            throw new TestErrorException("The query results were not isolated");
        }
        if (((AbstractSession)this.session).getIdentityMapAccessorInstance().getQueryResult((ReadQuery)this.query, null, false) == null) {
            throw new TestErrorException("The query results were not saved in the identity map.");
        }
        if (this.readEmployees.size() != 2) {
            throw new TestErrorException("The query results were not returned.");
        }
    }
}

