/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions;

import junit.framework.Test;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.DoNotUseDistinctTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.FirstResultTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.MaxRowsTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.MemoryQueryReturnConfirmedTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.MemoryQueryReturnNotConfirmedTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.MemoryQueryThrowExceptionTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.MemoryQueryTriggerIndirectionTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.QueryManagerTimeoutTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.QueryTimeOutTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.RefreshIdentityMapResultsTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.ShouldPrepareTest;
import org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions.UseDistinctTest;

public class QueryOptionTestSuite
extends TestSuite {
    public QueryOptionTestSuite() {
        this.setDescription("This suite tests all of the functionality of the query options.");
    }

    public void addTests() {
        this.addTest((Test)new RefreshIdentityMapResultsTest());
        this.addTest((Test)new QueryTimeOutTest());
        this.addTest((Test)new MaxRowsTest());
        this.addTest((Test)new FirstResultTest());
        this.addTest((Test)new MemoryQueryReturnConfirmedTest());
        this.addTest((Test)new MemoryQueryReturnNotConfirmedTest());
        this.addTest((Test)new MemoryQueryThrowExceptionTest());
        this.addTest((Test)new MemoryQueryTriggerIndirectionTest());
        this.addTest((Test)new DoNotUseDistinctTest());
        this.addTest((Test)new UseDistinctTest());
        this.addTest((Test)new ShouldPrepareTest());
        this.addTest((Test)new QueryManagerTimeoutTest());
        this.addTest((Test)this.buildReadOnlyTest());
        this.addTest((Test)this.buildJoinSubclassesTest());
    }

    public TestCase buildReadOnlyTest() {
        TestCase test = new TestCase(){

            public void test() {
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                Employee employee = (Employee)uow.executeQuery("readOnlyQuery", Employee.class);
                if (employee != this.getSession().readObject((Object)employee)) {
                    this.throwError("Read-only option not used, employee registered in the unit of work.");
                }
            }
        };
        test.setName("ReadOnlyTest");
        test.setDescription("Test the read-only query option in named queries.");
        return test;
    }

    public TestCase buildJoinSubclassesTest() {
        TestCase test = new TestCase(){

            public void test() {
                if (this.getSession().getPlatform().isSymfoware()) {
                    this.throwWarning("Test joinSubclassesQuery skipped on this platform, Symfoware supports scrollable cursors, but not in the way expected by this test.");
                }
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                Cursor cursor = (Cursor)uow.executeQuery("joinSubclassesQuery", Project.class);
                cursor.close();
            }
        };
        test.setName("JoinSubclassesTest");
        test.setDescription("Test the read-only query option in named queries.");
        return test;
    }
}

