/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.employee;

import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.eclipse.persistence.testing.tests.jpa.dynamic.employee.DynamicEmployeeSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MappingConfigTestSuite {
    static EntityManagerFactory emf = null;
    static JPADynamicHelper helper = null;
    static Server serverSession = null;

    @BeforeClass
    public static void setUp() throws Exception {
        emf = DynamicTestHelper.createEMF("dynamic");
        helper = new JPADynamicHelper(emf);
        DynamicEmployeeSystem.buildProject((DynamicHelper)helper);
        serverSession = JpaHelper.getServerSession((EntityManagerFactory)emf);
    }

    @AfterClass
    public static void tearDown() {
        try {
            serverSession.executeNonSelectingSQL("DELETE FROM D_PROJ_EMP");
            serverSession.executeNonSelectingSQL("DELETE FROM D_PHONE");
            serverSession.executeNonSelectingSQL("DELETE FROM D_SALARY");
            serverSession.executeNonSelectingSQL("DELETE FROM D_PROJECT");
            serverSession.executeNonSelectingSQL("DELETE FROM D_EMPLOYEE");
            serverSession.executeNonSelectingSQL("DELETE FROM D_ADDRESS");
            serverSession.executeNonSelectingSQL("DROP TABLE D_SALARY");
            serverSession.executeNonSelectingSQL("DROP TABLE D_PROJ_EMP");
            serverSession.executeNonSelectingSQL("DROP TABLE D_PROJECT");
            serverSession.executeNonSelectingSQL("DROP TABLE D_PHONE");
            serverSession.executeNonSelectingSQL("DROP TABLE D_EMPLOYEE");
            serverSession.executeNonSelectingSQL("DROP TABLE D_ADDRESS");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        helper = null;
        emf.close();
        emf = null;
    }

    @Test
    public void verifyServerSession() throws Exception {
        Assert.assertNotNull((Object)serverSession);
        Assert.assertTrue((boolean)serverSession.isConnected());
        Assert.assertTrue((boolean)serverSession.isServerSession());
        Assert.assertTrue((boolean)serverSession.getName().equals("dynamic"));
    }

    @Test
    public void verifyEmployeeDescriptor() throws Exception {
        ClassDescriptor descriptor = serverSession.getDescriptorForAlias("Employee");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"Employee", (Object)descriptor.getAlias());
        Assert.assertNull((Object)descriptor.getInheritancePolicyOrNull());
        OneToOneMapping addrMapping = (OneToOneMapping)descriptor.getMappingForAttributeName("address");
        Assert.assertNotNull((Object)addrMapping);
        Assert.assertTrue((boolean)addrMapping.isPrivateOwned());
        Assert.assertSame((Object)serverSession.getDescriptorForAlias("Address"), (Object)addrMapping.getReferenceDescriptor());
        OneToManyMapping phoneMapping = (OneToManyMapping)descriptor.getMappingForAttributeName("phoneNumbers");
        Assert.assertNotNull((Object)phoneMapping);
        Assert.assertTrue((boolean)phoneMapping.isPrivateOwned());
        Assert.assertSame((Object)serverSession.getDescriptorForAlias("PhoneNumber"), (Object)phoneMapping.getReferenceDescriptor());
        OneToOneMapping managerMapping = (OneToOneMapping)descriptor.getMappingForAttributeName("manager");
        Assert.assertNotNull((Object)managerMapping);
        Assert.assertFalse((boolean)managerMapping.isPrivateOwned());
        Assert.assertSame((Object)descriptor, (Object)managerMapping.getReferenceDescriptor());
        OneToManyMapping managedEmployeesMapping = (OneToManyMapping)descriptor.getMappingForAttributeName("managedEmployees");
        Assert.assertNotNull((Object)managedEmployeesMapping);
        Assert.assertFalse((boolean)managedEmployeesMapping.isPrivateOwned());
        Assert.assertSame((Object)descriptor, (Object)managedEmployeesMapping.getReferenceDescriptor());
        ManyToManyMapping projectsMapping = (ManyToManyMapping)descriptor.getMappingForAttributeName("projects");
        Assert.assertNotNull((Object)projectsMapping);
        Assert.assertFalse((boolean)projectsMapping.isPrivateOwned());
        Assert.assertSame((Object)serverSession.getDescriptorForAlias("Project"), (Object)projectsMapping.getReferenceDescriptor());
    }

    @Test
    public void verifyAddressDescriptor() throws Exception {
        ClassDescriptor descriptor = serverSession.getDescriptorForAlias("Address");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"Address", (Object)descriptor.getAlias());
        Assert.assertNull((Object)descriptor.getInheritancePolicyOrNull());
    }

    @Test
    public void verifyPhoneNumberDescriptor() {
        ClassDescriptor descriptor = serverSession.getDescriptorForAlias("PhoneNumber");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"PhoneNumber", (Object)descriptor.getAlias());
        Assert.assertNull((Object)descriptor.getInheritancePolicyOrNull());
    }

    @Test
    public void verifyProjectDescriptor() {
        ClassDescriptor descriptor = serverSession.getDescriptorForAlias("Project");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"Project", (Object)descriptor.getAlias());
        Assert.assertNull((Object)descriptor.getInheritancePolicyOrNull());
    }
}

