/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant;

import java.io.PrintStream;
import org.apache.tools.ant.BuildException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.tools.workbench.ant.ProjectRunner;
import org.eclipse.persistence.tools.workbench.ant.SessionValidatorInterface;

public class SessionValidator
extends ProjectRunner
implements SessionValidatorInterface {
    private DatabaseSession databaseSession;

    public SessionValidator() {
    }

    public SessionValidator(PrintStream log) {
        super(log);
    }

    @Override
    public int execute(String sessionName, String sessionsFileName, String url, String driverclass, String user, String password) {
        int status = 0;
        try {
            this.login(sessionName, sessionsFileName, url, driverclass, user, password);
        }
        catch (DatabaseException e) {
            String msg = e.getMessage() == null ? e.toString() : e.getMessage();
            throw new BuildException(this.stringRepository.getString("couldNotLogin", msg), (Throwable)e);
        }
        catch (Throwable e) {
            Throwable t = e.getCause() == null ? e : e.getCause();
            String msg = t.getMessage() == null ? t.toString() : t.getMessage();
            throw new BuildException(this.stringRepository.getString("errorWhileValidating", msg), e);
        }
        finally {
            this.logout();
        }
        return status;
    }

    private void login(String sessionName, String sessionsFileName, String url, String driverclass, String user, String password) {
        this.databaseSession = (DatabaseSession)SessionManager.getManager().getSession(new XMLSessionConfigLoader(sessionsFileName), sessionName, PrivilegedAccessHelper.getClassLoaderForClass(this.getClass()), false, false, false);
        DatabaseLogin sessionLogin = this.databaseSession.getLogin();
        if (url != "") {
            if (url != "") {
                sessionLogin.setDatabaseURL(url);
            }
            if (driverclass != "") {
                sessionLogin.setDriverClassName(driverclass);
            }
            if (user != "") {
                sessionLogin.setUserName(user);
            }
            if (password != "") {
                sessionLogin.setPassword(password);
            }
        }
        this.databaseSession.login((Login)sessionLogin);
    }

    private void logout() {
        if (this.databaseSession != null) {
            this.databaseSession.logout();
        }
    }
}

