/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class IntegerConstant
extends Constant {
    private int value;

    IntegerConstant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        super(pool, tag, stream);
    }

    @Override
    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.value = stream.readU4();
    }

    @Override
    public void displayStringOn(IndentingPrintWriter writer) {
        super.displayStringOn(writer);
        writer.print(" value: ");
        writer.println(this.value);
    }

    @Override
    public String description() {
        return "int";
    }

    @Override
    public void printFieldInitializationClauseOn(PrintWriter writer) {
        writer.print(this.value);
    }

    public int intValue() {
        return this.value;
    }

    @Override
    public Object value() {
        return new Integer(this.value);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

