/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ReadConnectionPoolConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;

public class ReadConnectionPoolAdapter
extends ConnectionPoolAdapter {
    public static final String EXCLUSIVE_PROPERTY = "exclusive";
    public static final String USE_NON_TRANSACTIONAL_READ_LOGIN_PROPERTY = "useNonTransactionalReadLogin";
    private volatile boolean useNonTransactionalReadLogin;

    ReadConnectionPoolAdapter(SCAdapter parent, ReadConnectionPoolConfig scConfig) {
        super(parent, (ConnectionPoolConfig)scConfig);
    }

    protected ReadConnectionPoolAdapter(SCAdapter parent) {
        super(parent, "ReadConnectionPool");
    }

    private final ReadConnectionPoolConfig readPool() {
        return (ReadConnectionPoolConfig)this.getModel();
    }

    @Override
    protected Object buildModel() {
        return new ReadConnectionPoolConfig();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setConfigRequired(true);
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setExclusive(true);
    }

    @Override
    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.setLogin(NullLoginAdapter.instance());
    }

    @Override
    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        this.useNonTransactionalReadLogin = this.readPool().getLoginConfig() != null;
    }

    @Override
    protected void postInitializationFromModel() {
        super.postInitializationFromModel();
        if (this.getName().equals("unamed")) {
            this.setName("ReadConnectionPool");
        }
    }

    public boolean isExclusive() {
        return this.readPool().getExclusive();
    }

    @Override
    public boolean isReadConnectionPool() {
        return true;
    }

    public void setExclusive(boolean exclusive) {
        boolean old = this.isExclusive();
        this.readPool().setExclusive(exclusive);
        this.firePropertyChanged(EXCLUSIVE_PROPERTY, old, exclusive);
    }

    public boolean usesNonTransactionalReadLogin() {
        return this.useNonTransactionalReadLogin;
    }

    public void setUseNonTransactionalReadLogin(boolean useNonTransactionalReadLogin) {
        boolean old = this.useNonTransactionalReadLogin;
        if (old == useNonTransactionalReadLogin) {
            return;
        }
        this.useNonTransactionalReadLogin = useNonTransactionalReadLogin;
        if (useNonTransactionalReadLogin) {
            this.setLogin(this.buildLogin());
        } else {
            this.removeLogin();
        }
        this.firePropertyChanged(USE_NON_TRANSACTIONAL_READ_LOGIN_PROPERTY, old, useNonTransactionalReadLogin);
    }
}

