/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class CompositeIcon
implements Icon,
Cloneable,
Serializable,
Accessible,
SwingConstants {
    Icon[] icons;
    private int[] gaps;
    private int orientation;
    public static final int[] VALID_ORIENTATION_VALUES = new int[]{0, 1};
    private int alignment;
    public static final int[] VALID_HORIZONTAL_ALIGNMENT_VALUES = new int[]{0, 1, 3};
    public static final int[] VALID_VERTICAL_ALIGNMENT_VALUES = new int[]{0, 10, 11};
    private boolean overrideLeftToRight;
    private String description;
    private AccessibleContext accessibleContext;
    private static final Icon[] EMPTY_ICONS = new Icon[0];
    private static final int[] EMPTY_GAPS = new int[0];
    private static final long serialVersionUID = 1L;

    public CompositeIcon(Icon[] icons, int[] gaps, int orientation, int alignment, String description) {
        if (icons.length == 0) {
            if (gaps.length != 0) {
                throw new IllegalArgumentException("if there are no icons, there can be no gaps either");
            }
        } else if (gaps.length != icons.length - 1) {
            throw new IllegalArgumentException("if there are icons, there must be 1 fewer gaps than icons");
        }
        this.icons = icons;
        this.gaps = gaps;
        this.checkOrientation(orientation);
        this.orientation = orientation;
        this.setAlignment(alignment);
        this.overrideLeftToRight = false;
        this.setDescription(description);
    }

    public CompositeIcon(Icon[] icons, int[] gaps) {
        this(icons, gaps, 0, 0, null);
    }

    public CompositeIcon() {
        this(EMPTY_ICONS, EMPTY_GAPS);
    }

    public CompositeIcon(Icon icon) {
        this(new Icon[]{icon}, EMPTY_GAPS);
    }

    public CompositeIcon(Icon icon1, int gap, Icon icon2) {
        this(new Icon[]{icon1, icon2}, new int[]{gap});
    }

    public CompositeIcon(Icon icon1, Icon icon2) {
        this(icon1, 0, icon2);
    }

    public CompositeIcon(Icon[] icons, int gap) {
        this(icons, CompositeIcon.buildFixedGapsFor(icons.length, gap));
    }

    public CompositeIcon(Icon[] icons) {
        this(icons, 0);
    }

    public CompositeIcon(List icons, int gap) {
        this(icons.toArray(new Icon[icons.size()]), gap);
    }

    public CompositeIcon(List icons) {
        this(icons, 0);
    }

    @Override
    public int getIconWidth() {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        if (this.orientation == 0) {
            int[] localGaps = this.gaps;
            int position = 0;
            int min = 0;
            int max = 0;
            int gapsLength = localGaps.length;
            for (int i = 0; i < iconsLength; ++i) {
                Icon icon = localIcons[i];
                if (icon != null) {
                    int n = max = max >= (position += icon.getIconWidth()) ? max : position;
                }
                if (i >= gapsLength) continue;
                max = max >= (position += localGaps[i]) ? max : position;
                min = min <= position ? min : position;
            }
            return max - min;
        }
        int width = 0;
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon == null) continue;
            int iconWidth = icon.getIconWidth();
            width = width >= iconWidth ? width : iconWidth;
        }
        return width;
    }

    @Override
    public int getIconHeight() {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        if (this.orientation == 1) {
            int[] localGaps = this.gaps;
            int position = 0;
            int min = 0;
            int max = 0;
            int gapsLength = localGaps.length;
            for (int i = 0; i < iconsLength; ++i) {
                Icon icon = localIcons[i];
                if (icon != null) {
                    int n = max = max >= (position += icon.getIconHeight()) ? max : position;
                }
                if (i >= gapsLength) continue;
                max = max >= (position += localGaps[i]) ? max : position;
                min = min <= position ? min : position;
            }
            return max - min;
        }
        int height = 0;
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon == null) continue;
            int iconHeight = icon.getIconHeight();
            height = height >= iconHeight ? height : iconHeight;
        }
        return height;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int x, int y) {
        if (this.orientation == 0) {
            this.paintIconHorizontally(component, g, x, y);
        } else {
            this.paintIconVertically(component, g, x, y);
        }
    }

    private void paintIconHorizontally(Component component, Graphics g, int x, int y) {
        if (this.isLeftToRight(component)) {
            this.paintIconLeftToRight(component, g, x, y);
        } else {
            this.paintIconRightToLeft(component, g, x, y);
        }
    }

    private void paintIconLeftToRight(Component component, Graphics g, int x, int y) {
        switch (this.alignment) {
            case 0: {
                this.paintIconLeftToRightCenterAligned(component, g, x, y);
                break;
            }
            case 1: {
                this.paintIconLeftToRightTopAligned(component, g, x, y);
                break;
            }
            case 3: {
                this.paintIconLeftToRightBottomAligned(component, g, x, y);
                break;
            }
            default: {
                throw new IllegalStateException("illegal alignment: " + this.alignment);
            }
        }
    }

    private void paintIconLeftToRightCenterAligned(Component component, Graphics g, int x, int y) {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        int[] localGaps = this.gaps;
        int gapsLength = localGaps.length;
        int totalHeight = this.getIconHeight();
        int position = x + this.calculateHorizontalStartOffset();
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                icon.paintIcon(component, g, position, y + (totalHeight - icon.getIconHeight() >> 1));
                position += icon.getIconWidth();
            }
            if (i >= gapsLength) continue;
            position += localGaps[i];
        }
    }

    private void paintIconLeftToRightTopAligned(Component component, Graphics g, int x, int y) {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        int[] localGaps = this.gaps;
        int gapsLength = localGaps.length;
        int position = x + this.calculateHorizontalStartOffset();
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                icon.paintIcon(component, g, position, y);
                position += icon.getIconWidth();
            }
            if (i >= gapsLength) continue;
            position += localGaps[i];
        }
    }

    private void paintIconLeftToRightBottomAligned(Component component, Graphics g, int x, int y) {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        int[] localGaps = this.gaps;
        int gapsLength = localGaps.length;
        int bottom = y + this.getIconHeight();
        int position = x + this.calculateHorizontalStartOffset();
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                icon.paintIcon(component, g, position, bottom - icon.getIconHeight());
                position += icon.getIconWidth();
            }
            if (i >= gapsLength) continue;
            position += localGaps[i];
        }
    }

    private int calculateHorizontalStartOffset() {
        Icon[] localIcons = this.icons;
        int[] localGaps = this.gaps;
        int position = 0;
        int min = 0;
        int gapsLength = localGaps.length;
        for (int i = 0; i < gapsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                position += icon.getIconWidth();
            }
            min = min <= (position += localGaps[i]) ? min : position;
        }
        return min < 0 ? -min : min;
    }

    private void paintIconRightToLeft(Component component, Graphics g, int x, int y) {
        switch (this.alignment) {
            case 0: {
                this.paintIconRightToLeftCenterAligned(component, g, x, y);
                break;
            }
            case 1: {
                this.paintIconRightToLeftTopAligned(component, g, x, y);
                break;
            }
            case 3: {
                this.paintIconRightToLeftBottomAligned(component, g, x, y);
                break;
            }
            default: {
                throw new IllegalStateException("illegal alignment: " + this.alignment);
            }
        }
    }

    private void paintIconRightToLeftCenterAligned(Component component, Graphics g, int x, int y) {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        int[] localGaps = this.gaps;
        int gapsLength = localGaps.length;
        int totalHeight = this.getIconHeight();
        int position = x + this.getIconWidth() - this.calculateHorizontalStartOffset();
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                icon.paintIcon(component, g, position -= icon.getIconWidth(), y + (totalHeight - icon.getIconHeight() >> 1));
            }
            if (i >= gapsLength) continue;
            position -= localGaps[i];
        }
    }

    private void paintIconRightToLeftTopAligned(Component component, Graphics g, int x, int y) {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        int[] localGaps = this.gaps;
        int gapsLength = localGaps.length;
        int position = x + this.getIconWidth() - this.calculateHorizontalStartOffset();
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                icon.paintIcon(component, g, position -= icon.getIconWidth(), y);
            }
            if (i >= gapsLength) continue;
            position -= localGaps[i];
        }
    }

    private void paintIconRightToLeftBottomAligned(Component component, Graphics g, int x, int y) {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        int[] localGaps = this.gaps;
        int gapsLength = localGaps.length;
        int bottom = y + this.getIconHeight();
        int position = x + this.getIconWidth() - this.calculateHorizontalStartOffset();
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                icon.paintIcon(component, g, position -= icon.getIconWidth(), bottom - icon.getIconHeight());
            }
            if (i >= gapsLength) continue;
            position -= localGaps[i];
        }
    }

    private void paintIconVertically(Component component, Graphics g, int x, int y) {
        if (this.isLeftToRight(component)) {
            this.paintIconTopToBottomLeadingEdgeOnLeft(component, g, x, y);
        } else {
            this.paintIconTopToBottomLeadingEdgeOnRight(component, g, x, y);
        }
    }

    private void paintIconTopToBottomLeadingEdgeOnLeft(Component component, Graphics g, int x, int y) {
        switch (this.alignment) {
            case 0: {
                this.paintIconTopToBottomCenterAligned(component, g, x, y);
                break;
            }
            case 10: {
                this.paintIconTopToBottomLeftAligned(component, g, x, y);
                break;
            }
            case 11: {
                this.paintIconTopToBottomRightAligned(component, g, x, y);
                break;
            }
            default: {
                throw new IllegalStateException("illegal alignment: " + this.alignment);
            }
        }
    }

    private void paintIconTopToBottomCenterAligned(Component component, Graphics g, int x, int y) {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        int[] localGaps = this.gaps;
        int gapsLength = localGaps.length;
        int totalWidth = this.getIconWidth();
        int position = y + this.calculateVerticalStartOffset();
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                icon.paintIcon(component, g, x + (totalWidth - icon.getIconWidth() >> 1), position);
                position += icon.getIconHeight();
            }
            if (i >= gapsLength) continue;
            position += localGaps[i];
        }
    }

    private void paintIconTopToBottomLeftAligned(Component component, Graphics g, int x, int y) {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        int[] localGaps = this.gaps;
        int gapsLength = localGaps.length;
        int position = y + this.calculateVerticalStartOffset();
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                icon.paintIcon(component, g, x, position);
                position += icon.getIconHeight();
            }
            if (i >= gapsLength) continue;
            position += localGaps[i];
        }
    }

    private void paintIconTopToBottomRightAligned(Component component, Graphics g, int x, int y) {
        Icon[] localIcons = this.icons;
        int iconsLength = localIcons.length;
        int[] localGaps = this.gaps;
        int gapsLength = localGaps.length;
        int right = x + this.getIconWidth();
        int position = y + this.calculateVerticalStartOffset();
        for (int i = 0; i < iconsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                icon.paintIcon(component, g, right - icon.getIconWidth(), position);
                position += icon.getIconHeight();
            }
            if (i >= gapsLength) continue;
            position += localGaps[i];
        }
    }

    private int calculateVerticalStartOffset() {
        Icon[] localIcons = this.icons;
        int[] localGaps = this.gaps;
        int position = 0;
        int min = 0;
        int gapsLength = localGaps.length;
        for (int i = 0; i < gapsLength; ++i) {
            Icon icon = localIcons[i];
            if (icon != null) {
                position += icon.getIconHeight();
            }
            min = min <= (position += localGaps[i]) ? min : position;
        }
        return min < 0 ? -min : min;
    }

    private void paintIconTopToBottomLeadingEdgeOnRight(Component component, Graphics g, int x, int y) {
        switch (this.alignment) {
            case 0: {
                this.paintIconTopToBottomCenterAligned(component, g, x, y);
                break;
            }
            case 10: {
                this.paintIconTopToBottomRightAligned(component, g, x, y);
                break;
            }
            case 11: {
                this.paintIconTopToBottomLeftAligned(component, g, x, y);
                break;
            }
            default: {
                throw new IllegalStateException("illegal alignment: " + this.alignment);
            }
        }
    }

    public Object clone() {
        CompositeIcon clone;
        try {
            clone = (CompositeIcon)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        clone.icons = new Icon[this.icons.length];
        System.arraycopy(this.icons, 0, clone.icons, 0, this.icons.length);
        clone.gaps = new int[this.gaps.length];
        System.arraycopy(this.gaps, 0, clone.gaps, 0, this.gaps.length);
        clone.accessibleContext = null;
        return clone;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCompositeIcon();
        }
        return this.accessibleContext;
    }

    public String toString() {
        return "CompositeIcon(" + this.icons.length + " icons)";
    }

    public Icon getIcon(int index) {
        return this.icons[index];
    }

    public void setIcon(int index, Icon icon) {
        this.icons[index] = icon;
    }

    public int iconCount() {
        return this.icons.length;
    }

    public int getGap(int index) {
        return this.gaps[index];
    }

    public void setGap(int index, int gap) {
        this.gaps[index] = gap;
    }

    public int gapCount() {
        return this.gaps.length;
    }

    private void addIcons(Icon[] extraIcons) {
        Icon[] oldIcons = this.icons;
        int oldLen = oldIcons.length;
        int extraLen = extraIcons.length;
        Icon[] newIcons = new Icon[oldLen + extraLen];
        System.arraycopy(oldIcons, 0, newIcons, 0, oldLen);
        System.arraycopy(extraIcons, 0, newIcons, oldLen, extraLen);
        this.icons = newIcons;
    }

    private void addGaps(int[] extraGaps) {
        int[] oldGaps = this.gaps;
        int oldLen = oldGaps.length;
        int extraLen = extraGaps.length;
        int[] newGaps = new int[oldLen + extraLen];
        System.arraycopy(oldGaps, 0, newGaps, 0, oldLen);
        System.arraycopy(extraGaps, 0, newGaps, oldLen, extraLen);
        this.gaps = newGaps;
    }

    public void addAll(Icon[] extraIcons, int[] extraGaps) {
        if (extraIcons.length == 0) {
            return;
        }
        if (this.icons.length == 0) {
            if (extraGaps.length != extraIcons.length - 1) {
                throw new IllegalArgumentException("there must be 1 fewer gaps than icons with the first addition to the composite");
            }
        } else if (extraGaps.length != extraIcons.length) {
            throw new IllegalArgumentException("there must be same number of gaps as icons on subsequent additions to the composite");
        }
        this.addIcons(extraIcons);
        this.addGaps(extraGaps);
    }

    public void addAll(Icon[] extraIcons, int gap) {
        this.addAll(extraIcons, CompositeIcon.buildFixedGapsFor(extraIcons.length, gap));
    }

    public void addAll(Icon[] extraIcons) {
        this.addAll(extraIcons, 0);
    }

    public void addAll(List extraIcons, int gap) {
        this.addAll(extraIcons.toArray(new Icon[extraIcons.size()]), gap);
    }

    public void addAll(List extraIcons) {
        this.addAll(extraIcons, 0);
    }

    public void add(Icon icon, int gap) {
        if (this.icons.length == 0) {
            this.icons = new Icon[]{icon};
        } else {
            this.addAll(new Icon[]{icon}, new int[]{gap});
        }
    }

    public void add(Icon icon) {
        this.add(icon, 0);
    }

    public void clear() {
        this.icons = EMPTY_ICONS;
        this.gaps = EMPTY_GAPS;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.checkOrientation(orientation);
        this.alignment = 0;
        this.orientation = orientation;
    }

    private void checkOrientation(int orient) {
        if (!CollectionTools.contains((int[])VALID_ORIENTATION_VALUES, (int)orient)) {
            throw new IllegalArgumentException("invalid orientation: " + orient);
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.checkAlignment(alignment);
        this.alignment = alignment;
    }

    private void checkAlignment(int align) {
        if (this.orientation == 0) {
            if (!CollectionTools.contains((int[])VALID_HORIZONTAL_ALIGNMENT_VALUES, (int)align)) {
                throw new IllegalArgumentException("invalid horizontal alignment: " + align);
            }
        } else if (!CollectionTools.contains((int[])VALID_VERTICAL_ALIGNMENT_VALUES, (int)align)) {
            throw new IllegalArgumentException("invalid vertical alignment: " + align);
        }
    }

    public boolean isOverrideLeftToRight() {
        return this.overrideLeftToRight;
    }

    public void setOverrideLeftToRight(boolean overrideLeftToRight) {
        this.overrideLeftToRight = overrideLeftToRight;
    }

    private boolean isLeftToRight(Component component) {
        return this.overrideLeftToRight || component.getComponentOrientation().isLeftToRight();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private static int[] buildFixedGapsFor(int iconsLength, int gap) {
        if (iconsLength == 0) {
            return EMPTY_GAPS;
        }
        return CollectionTools.fill((int[])new int[iconsLength - 1], (int)gap);
    }

    protected class AccessibleCompositeIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        protected AccessibleCompositeIcon() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        @Override
        public Accessible getAccessibleParent() {
            return null;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            Icon[] localIcons = CompositeIcon.this.icons;
            int len = localIcons.length;
            int count = 0;
            for (int i = 0; i < len; ++i) {
                if (!(localIcons[i] instanceof Accessible)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Accessible getAccessibleChild(int index) {
            Icon[] localIcons = CompositeIcon.this.icons;
            int len = localIcons.length;
            int count = 0;
            for (int i = 0; i < len; ++i) {
                Icon icon = localIcons[i];
                if (!(icon instanceof Accessible)) continue;
                if (count == index) {
                    return (Accessible)((Object)icon);
                }
                ++count;
            }
            return null;
        }

        @Override
        public Locale getLocale() {
            return null;
        }

        @Override
        public String getAccessibleIconDescription() {
            return CompositeIcon.this.getDescription();
        }

        @Override
        public void setAccessibleIconDescription(String description) {
            CompositeIcon.this.setDescription(description);
        }

        @Override
        public int getAccessibleIconHeight() {
            return CompositeIcon.this.getIconHeight();
        }

        @Override
        public int getAccessibleIconWidth() {
            return CompositeIcon.this.getIconWidth();
        }
    }
}

