/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project;

import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWTransactionalProjectCachingPolicy;

public abstract class MWTransactionalProjectDefaultsPolicy
extends MWProjectDefaultsPolicy {
    public static final String EVENTS_POLICY = "Events";
    public static final String RETURNING_POLICY = "Returning";

    protected MWTransactionalProjectDefaultsPolicy() {
    }

    public MWTransactionalProjectDefaultsPolicy(MWModel parent) {
        super(parent);
    }

    @Override
    protected MWCachingPolicy buildCachingPolicy() {
        return new MWTransactionalProjectCachingPolicy(this);
    }

    @Override
    protected void initializePolicyDescriptors() {
        super.initializePolicyDescriptors();
        this.addPolicyDescriptor(EVENTS_POLICY, new EventsPolicyDescriptor());
        this.addPolicyDescriptor(RETURNING_POLICY, new ReturningPolicyDescriptor());
    }

    private class ReturningPolicyDescriptor
    implements MWProjectDefaultsPolicy.PolicyDescriptor {
        private ReturningPolicyDescriptor() {
        }

        @Override
        public void applyPolicyToDescriptor(MWMappingDescriptor descriptor) {
            if (descriptor.supportsReturningPolicy()) {
                ((MWTransactionalDescriptor)((Object)descriptor)).addReturningPolicy();
            }
        }
    }

    private class EventsPolicyDescriptor
    implements MWProjectDefaultsPolicy.PolicyDescriptor {
        private EventsPolicyDescriptor() {
        }

        @Override
        public void applyPolicyToDescriptor(MWMappingDescriptor descriptor) {
            if (!descriptor.getEventsPolicy().isActive()) {
                descriptor.addEventsPolicy();
            }
        }
    }
}

