/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLTools {
    private static DocumentBuilderFactory documentBuilderFactory;
    private static DocumentBuilder documentBuilder;
    private static TransformerFactory transformerFactory;
    private static Transformer transformer;

    private static synchronized DocumentBuilderFactory documentBuilderFactory() {
        if (documentBuilderFactory == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return documentBuilderFactory;
    }

    private static synchronized DocumentBuilder documentBuilder() {
        if (documentBuilder == null) {
            try {
                documentBuilder = XMLTools.documentBuilderFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex);
            }
        }
        return documentBuilder;
    }

    public static synchronized Document parse(InputSource inputSource) {
        try {
            return XMLTools.documentBuilder().parse(inputSource);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Document parse(Reader reader) {
        Document document = null;
        try {
            document = XMLTools.parse(new InputSource(reader));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return document;
    }

    public static Document parse(InputStream inputStream) {
        try {
            return XMLTools.parse(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Document parse(File file) {
        BufferedInputStream inputStream;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file), 8192);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        Document document = XMLTools.parse(inputStream);
        try {
            ((InputStream)inputStream).close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return document;
    }

    public static Node child(Node parent, String childName) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    public static Node[] children(Node node) {
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        ArrayList<Node> result = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            result.add(child);
        }
        return result.toArray(new Node[result.size()]);
    }

    public static Node[] children(Node node, String childName) {
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        ArrayList<Node> result = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(childName)) continue;
            result.add(child);
        }
        return result.toArray(new Node[result.size()]);
    }

    public static String textContent(Node node) {
        Node child;
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return "";
        }
        if (children.getLength() == 1 && (child = children.item(0)).getNodeType() == 3) {
            return node.getFirstChild().getNodeValue();
        }
        throw new IllegalArgumentException(node.getNodeName());
    }

    public static String childTextContent(Node parent, String childName) {
        return XMLTools.textContent(XMLTools.child(parent, childName));
    }

    public static String childTextContent(Node parent, String childName, String defaultValue) {
        Node child = XMLTools.child(parent, childName);
        if (child == null) {
            return defaultValue;
        }
        return XMLTools.textContent(child);
    }

    public static int childIntContent(Node parent, String childName) {
        return XMLTools.convertToInt(XMLTools.textContent(XMLTools.child(parent, childName)));
    }

    public static int childIntContent(Node parent, String childName, int defaultValue) {
        Node child = XMLTools.child(parent, childName);
        if (child == null) {
            return defaultValue;
        }
        return XMLTools.convertToInt(XMLTools.textContent(child));
    }

    private static int convertToInt(String string) {
        return Integer.parseInt(string);
    }

    public static boolean childBooleanContent(Node parent, String childName) {
        return XMLTools.convertToBoolean(XMLTools.textContent(XMLTools.child(parent, childName)));
    }

    public static boolean childBooleanContent(Node parent, String childName, boolean defaultValue) {
        Node child = XMLTools.child(parent, childName);
        if (child == null) {
            return defaultValue;
        }
        return XMLTools.convertToBoolean(XMLTools.textContent(child));
    }

    private static boolean convertToBoolean(String string) {
        String s = string.toLowerCase();
        if (s.equals("t") || s.equals("true") || s.equals("1")) {
            return true;
        }
        if (s.equals("f") || s.equals("false") || s.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException(string);
    }

    public static Document newDocument() {
        return XMLTools.documentBuilder().newDocument();
    }

    public static void addSimpleTextNode(Node parent, String childName, String text) {
        Element child = parent.getOwnerDocument().createElement(childName);
        Text childTextNode = parent.getOwnerDocument().createTextNode(text);
        child.appendChild(childTextNode);
        parent.appendChild(child);
    }

    public static void addSimpleTextNode(Node parent, String childName, String text, String defaultValue) {
        if (!text.equals(defaultValue)) {
            XMLTools.addSimpleTextNode(parent, childName, text);
        }
    }

    public static void addSimpleTextNode(Node parent, String childName, int text) {
        XMLTools.addSimpleTextNode(parent, childName, String.valueOf(text));
    }

    public static void addSimpleTextNode(Node parent, String childName, int text, int defaultValue) {
        if (text != defaultValue) {
            XMLTools.addSimpleTextNode(parent, childName, text);
        }
    }

    public static void addSimpleTextNode(Node parent, String childName, boolean text) {
        XMLTools.addSimpleTextNode(parent, childName, String.valueOf(text));
    }

    public static void addSimpleTextNode(Node parent, String childName, boolean text, boolean defaultValue) {
        if (text != defaultValue) {
            XMLTools.addSimpleTextNode(parent, childName, text);
        }
    }

    public static void addSimpleTextNodes(Node parent, String childrenName, String childName, String[] childrenTexts) {
        Element childrenNode = parent.getOwnerDocument().createElement(childrenName);
        parent.appendChild(childrenNode);
        int len = childrenTexts.length;
        for (int i = 0; i < len; ++i) {
            XMLTools.addSimpleTextNode((Node)childrenNode, childName, childrenTexts[i]);
        }
    }

    private static synchronized TransformerFactory transformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    private static synchronized Transformer transformer() {
        if (transformer == null) {
            try {
                transformer = XMLTools.transformerFactory().newTransformer();
            }
            catch (TransformerConfigurationException ex) {
                throw new RuntimeException(ex);
            }
            try {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return transformer;
    }

    public static synchronized void print(Source source, Result result) {
        try {
            XMLTools.transformer().transform(source, result);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void print(Document document, OutputStream outputStream) {
        XMLTools.print(new DOMSource(document), new StreamResult(outputStream));
    }

    public static void print(Document document, File file) {
        BufferedOutputStream outputStream;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file), 8192);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        XMLTools.print(document, outputStream);
        try {
            ((OutputStream)outputStream).close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private XMLTools() {
        throw new UnsupportedOperationException();
    }
}

