/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.lang.instrument.IllegalClassFormatException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.ClassDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassWeaver;
import org.eclipse.persistence.internal.jpa.weaving.ComputeClassWriter;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.commons.SerialVersionUIDAdder;
import org.eclipse.persistence.internal.logging.StdErrLogger;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderFromCurrentThread;
import org.eclipse.persistence.sessions.Session;

public class PersistenceWeaver
implements ClassTransformer {
    protected Map<String, ClassDetails> classDetailsMap;

    public PersistenceWeaver(Session session, Map<String, ClassDetails> classDetailsMap) {
        this.classDetailsMap = classDetailsMap;
    }

    public PersistenceWeaver(Map<String, ClassDetails> classDetailsMap) {
        this.classDetailsMap = classDetailsMap;
    }

    public void clear() {
        this.classDetailsMap = null;
    }

    public Map<String, ClassDetails> getClassDetailsMap() {
        return this.classDetailsMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean shouldLogFinest;
        block25: {
            shouldLogFinest = StdErrLogger.shouldLog(1, "weaver");
            Map<String, ClassDetails> classDetailsMap = this.classDetailsMap;
            if (classDetailsMap == null) {
                return null;
            }
            try {
                ClassDetails classDetails = classDetailsMap.get(Helper.toSlashedClassName(className));
                if (classDetails != null) {
                    ClassWriter classWriter;
                    if (shouldLogFinest) {
                        StdErrLogger.log(1, "weaver", "begin_weaving_class", className);
                    }
                    ClassReader classReader = new ClassReader(classfileBuffer);
                    String reflectiveIntrospectionProperty = PrivilegedAccessHelper.getSystemProperty("eclipselink.weaving.reflective-introspection");
                    ClassWriter classWriter2 = classWriter = reflectiveIntrospectionProperty != null ? new ClassWriter(2) : new ComputeClassWriter(loader, 2);
                    if (shouldLogFinest) {
                        ClassLoader contextClassLoader;
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                contextClassLoader = AccessController.doPrivileged(new PrivilegedGetClassLoaderFromCurrentThread());
                            }
                            catch (PrivilegedActionException ex) {
                                throw (RuntimeException)ex.getCause();
                            }
                        } else {
                            contextClassLoader = Thread.currentThread().getContextClassLoader();
                        }
                        if (reflectiveIntrospectionProperty != null) {
                            StdErrLogger.log(1, "weaver", "weaving_init_class_writer", className, Integer.toHexString(System.identityHashCode(contextClassLoader)));
                        } else {
                            StdErrLogger.log(1, "weaver", "weaving_init_compute_class_writer", className, Integer.toHexString(System.identityHashCode(contextClassLoader)), loader != null ? Integer.toHexString(System.identityHashCode(loader)) : "null");
                        }
                    }
                    ClassWeaver classWeaver = new ClassWeaver(classWriter, classDetails);
                    SerialVersionUIDAdder sv = new SerialVersionUIDAdder(classWeaver);
                    classReader.accept(sv, 0);
                    if (classWeaver.alreadyWeaved) {
                        if (shouldLogFinest) {
                            StdErrLogger.log(1, "weaver", "end_weaving_class", className);
                        }
                        return null;
                    }
                    if (classWeaver.weaved) {
                        byte[] bytes = classWriter.toByteArray();
                        String outputPath = PrivilegedAccessHelper.getSystemProperty("eclipselink.weaving.output.path", "");
                        if (!outputPath.equals("")) {
                            Helper.outputClassFile(className, bytes, outputPath);
                        }
                        if (shouldLogFinest) {
                            if (classWeaver.weavedPersistenceEntity) {
                                StdErrLogger.log(1, "weaver", "weaved_persistenceentity", className);
                            }
                            if (classWeaver.weavedChangeTracker) {
                                StdErrLogger.log(1, "weaver", "weaved_changetracker", className);
                            }
                            if (classWeaver.weavedLazy) {
                                StdErrLogger.log(1, "weaver", "weaved_lazy", className);
                            }
                            if (classWeaver.weavedFetchGroups) {
                                StdErrLogger.log(1, "weaver", "weaved_fetchgroups", className);
                            }
                            if (classWeaver.weavedRest) {
                                StdErrLogger.log(1, "weaver", "weaved_rest", className);
                            }
                            StdErrLogger.log(1, "weaver", "end_weaving_class", className);
                        }
                        return bytes;
                    }
                    if (shouldLogFinest) {
                        StdErrLogger.log(1, "weaver", "end_weaving_class", className);
                    }
                    break block25;
                }
                if (shouldLogFinest) {
                    StdErrLogger.log(1, "weaver", "transform_missing_class_details", className);
                }
            }
            catch (Throwable exception) {
                if (!StdErrLogger.shouldLog(6, "weaver")) break block25;
                StdErrLogger.log(6, "weaver", "exception_while_weaving", exception, className);
                if (!shouldLogFinest) break block25;
                StdErrLogger.logThrowable(1, "weaver", exception);
            }
        }
        if (shouldLogFinest) {
            StdErrLogger.log(1, "weaver", "transform_existing_class_bytes", className);
        }
        return null;
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }
}

