/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;

public class SendNewObjectCacheSyncTest
extends ConfigurableCacheSyncDistributedTest {
    protected Employee employee = null;
    protected boolean shouldSendObject = false;

    public SendNewObjectCacheSyncTest(boolean shouldSendObject) {
        this.shouldSendObject = shouldSendObject;
        if (shouldSendObject) {
            this.setName("SendNewObjectCacheSyncTest - SEND_NEW_OBJECTS_WITH_CHANGES");
            this.cacheSyncConfigValues.put(Employee.class, new Integer(3));
        } else {
            this.setName("SendNewObjectCacheSyncTest - SEND_OBJECT_CHANGES");
            this.cacheSyncConfigValues.put(Employee.class, new Integer(1));
        }
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.employee = new Employee();
        this.employee.setFirstName("Dave");
        this.employee.setLastName("Kujan");
        uow.registerObject((Object)this.employee);
        uow.commit();
    }

    public void verify() {
        if (this.shouldSendObject && this.getObjectFromDistributedCache(this.employee) == null) {
            throw new TestErrorException("New employee was not added to distributed cache with  SEND_NEW_OBJECTS_WITH_CHANGES descriptor CacheSynchronizationTypeSetting.");
        }
        if (!this.shouldSendObject && this.getObjectFromDistributedCache(this.employee) != null) {
            throw new TestErrorException("New employee was added to distributed cache with SEND_OBJECT_CHANGES descriptor CacheSynchronizationTypeSetting. It should not be added since it is not related to any objects being sent.");
        }
    }
}

